#ifndef __BDB_H__
#define __BDB_H__

/**************************/
/* BerkeleyDB environment */
/**************************/
extern DB_ENV *dbenv;
extern DB *unwanted_user;      	/* berkeleyDB of all users we must ignore */
extern DB *unode_db;					/* berkeleyDB of all known unodes */
extern DB *uaddr_ready_db;     	/* berkeleyDB of all UADDR ready to be used */
extern DB *uaddr_partial_db;   	/* berkeleyDB of all UADDR where only the IP is known */

/********************************************/
/* close dctc DBs and exit Berkeley library */
/********************************************/
void do_berkeley_exit(void);

/********************************************************************/
/* initialize berkeleyDB library and check/create and open dctc DBs */
/********************************************************************/
void do_berkeley_init(void);

/***************************/
/* get data of a given key */
/****************************************************************************/
/* output: 0=ok, !=0 not found                                              */
/*         if ok, *data_val contains the data (to free when no more useful) */
/*                *data_len is the length of the data                       */
/****************************************************************************/
int get_key_data(DB *table, void *key_val, const int key_len, void **data_val, int *data_len);

/***************************/
/* set data of a given key */
/***************************/
/* output: 0=ok, !=0 error */
/***************************/
int set_key_data(DB *table, void *key_val, const int key_len, void *data_val, const int data_len);

/******************************/
/* del data and the given key */
/******************************/
/* output: 0=ok, !=0 error */
/***************************/
int del_key_data(DB *table, void *key_val, const int key_len);

#endif
