#!/bin/sh

# EDIT THESE PROPERTIES TO REFLECT YOUR SYSTEM

dbNames="dcl"       # Database names where DCL's stuff resides
host="localhost"    # IP/Name of host machine running Postgres
port="5432"         # Port on that machine that Postgres is listening on
connectUser="dcl"   # User to connect to database as
grantTo="dcl"       # Database user to give access to

# EVERYTHING BELOW THIS LINE IS SAFE (I HOPE) TO LEAVE ALONE
# ----------------------------------------------------------------------
# All the tables
tables="accounts actions departments personnel priorities products dcl_projects projectmap severities statuses tickets ticketresolutions timecards watches workorders priorities severities tickets ticketresolutions faq faqtopics faqquestions faqanswers views attributesets attributesetsmap dcl_config dcl_chklst dcl_chklst_tpl dcl_status_type dcl_product_module dcl_wo_account dcl_wo_type dcl_session dcl_preferences dcl_wiki"

# All the sequences
sequences="seq_accounts seq_actions seq_departments seq_jcn seq_personnel seq_priorities seq_products seq_projects seq_severity seq_statuses seq_tickets seq_ticketresolutions seq_timecards seq_attributesets seq_views seq_tickets seq_ticketresolutions seq_faq seq_faqtopics seq_faqquestions seq_faqanswers seq_watches seq_dcl_chklst seq_dcl_chklst_tpl seq_dcl_product_module seq_dcl_wo_type"

# For all databases
for d in $dbNames
do
	echo "Processing database '$d'"
	# For all tabes and sequences in a database
	for x in $tables $sequences
	do
		echo "GRANT ALL ON $x TO \"$grantTo\";" >> grant.sql.tmp
	done

	psql -U $connectUser -d "$d" -h $host -p $port -q -e < grant.sql.tmp
	echo "Database $d grant all completed."
	sleep 1
	rm -f grant.sql.tmp
done
