<?php
/*
 * $Id: class.boTickets.inc.php,v 1.10.2.2.2.12 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');
LoadStringResource('tck');

class boTickets
{
	function search()
	{
		commonHeader();

		$obj = CreateObject('dcl.htmlTicketSearches');
		$obj->DisplaySearchForm();
	}

	function add()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlTicketForm');
		$obj->Show();
	}

	function dbadd()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();

		$obj->InitFromGlobals();
		$obj->createdby = $GLOBALS['DCLID'];

		// If responsible is set, InitFromGlobals would have fetched it above
		// If not set, get the ticket lead for the product
		if (!IsSet($GLOBALS['responsible']))
		{
			$objProduct = CreateObject('dcl.dbProducts');
			$objProduct->Connect($obj->conn);
			$objProduct->Load($obj->product);
			$obj->responsible = $objProduct->ticketsto;
		}

		$obj->statuson = date($dcl_info['DCL_TIMESTAMP_FORMAT']);

		if ($GLOBALS['resolution'] != '')
			$obj->lastactionon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);

		$oStatus = CreateObject('dcl.dbStatuses');
		if ($oStatus->GetStatusType($obj->status) == 2)
		{
			$obj->closedby = $GLOBALS['DCLID'];
			$obj->closedon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
		}

		$obj->seconds = 0;
		$obj->Add();

		// upload a file attachment?
		if (IsSet($GLOBALS['userfile']) && $GLOBALS['userfile'] != 'none')
		{
			if (!((IsSet($HTTP_POST_VARS['userfile']) && $HTTP_POST_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_GET_VARS['userfile']) && $HTTP_GET_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_COOKIE_VARS['userfile']) && $HTTP_COOKIE_VARS['userfile'] == $GLOBALS['userfile'])))
			{
				$o = CreateObject('dcl.boFile');
				$o->iType = ATTACHMENT_TICKET;
				$o->iKey1 = $obj->ticketid;
				$o->sFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['name'] : $GLOBALS['userfile_name'];
				$o->sTempFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['tmp_name'] : $GLOBALS['userfile'];
				$o->sRoot = $dcl_info['DCL_FILE_PATH'] . '/attachments';
				$o->Upload();
			}
		}

		if ($GLOBALS['resolution'] != '')
		{
			$objR = CreateObject('dcl.dbTicketresolutions');
			$objR->Connect($obj->conn);
			$objR->InitFromGlobals();
			$objR->loggedby = $GLOBALS['DCLID'];
			$objR->loggedon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
			$objR->ticketid = $obj->ticketid;
			$objR->Add();

			$start = new DCLTimestamp;
			$start->SetFromDisplay($objR->startedon);

			$end = new DCLTimestamp;
			$end->SetFromDisplay($objR->loggedon);

			$obj->seconds += ($end->time - $start->time);
			$obj->Edit();
		}

		$notify = '4,1';
		if ($oStatus->GetStatusType($obj->status) == 2)
			$notify .= ',2,3';

		$objWatch = CreateObject('dcl.boWatches');
		$objWatch->sendTicketNotification($obj, $notify);

		$objTR = CreateObject('dcl.boTicketresolutions');
		$objTR->sendCustomerResponseEmail($obj);

		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj);
	}

	// THANKS: Michael Brader
	function copyToWO()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($GLOBALS['ticketid']);

		$objHWO = CreateObject('dcl.htmlWorkOrderForm');
		$objHWO->Show(0, '', $obj);
	}

	function modify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_MOD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($GLOBALS['ticketid']);

		$objF = CreateObject('dcl.htmlTicketForm');
		$objF->Show($obj);

		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj);
	}

	function dbmodify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_MOD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($GLOBALS['ticketid']);

		$obj->product = $GLOBALS['product'];
		$obj->module_id = $GLOBALS['module_id'];
		$obj->account = $GLOBALS['account'];
		$obj->priority = $GLOBALS['priority'];
		$obj->type = $GLOBALS['type'];

		$obj->summary = $obj->GPCStripSlashes($GLOBALS['summary']);
		$obj->version = $obj->GPCStripSlashes($GLOBALS['version']);
		$obj->contact = $obj->GPCStripSlashes($GLOBALS['contact']);
		$obj->issue = $obj->GPCStripSlashes($GLOBALS['issue']);
		$obj->contactphone = $obj->GPCStripSlashes($GLOBALS['contactphone']);
		$obj->contactemail = $obj->GPCStripSlashes($GLOBALS['contactemail']);

		$oldResponsible = $obj->responsible;
		if (!IsSet($GLOBALS['responsible']))
		{
			$objProduct = CreateObject('dcl.dbProducts');
			$objProduct->Connect($obj->conn);
			$objProduct->Load($obj->product);
			$obj->responsible = $objProduct->ticketsto;
		}
		else
			$obj->responsible = $GLOBALS['responsible'];

		$obj->Edit();

		$objWtch = CreateObject('dcl.boWatches');
		$objWtch->sendTicketNotification($obj, '4');

		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj);
	}

	function delete()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_DEL_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($GLOBALS['ticketid']);

		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj, 0, true);
	}

	function dbdelete()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_DEL_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->ticketid = $GLOBALS['ticketid'];

		$obj->Delete();

		// Remove all attachments
		$attachPath = $dcl_info['DCL_FILE_PATH'] . '/attachments/tck/' . substr($GLOBALS['ticketid'], -1) . '/' . $GLOBALS['ticketid'] . '/';
		if (is_dir($attachPath) && $hDir = opendir($attachPath))
		{
			while ($fileName = readdir($hDir))
			{
				if (is_file($attachPath . $fileName) && is_readable($attachPath . $fileName))
					unlink($attachPath . $fileName);
			}

			closedir($hDir);
		}

		print('<center>');
		PrintWithChocoFont(sprintf(STR_BO_TICKETDELETED, $GLOBALS['ticketid']));
		print('</center>');

		$objMy = CreateObject('dcl.htmlMyDCL');
		$objMy->showMy();
	}

	function view()
	{
		commonHeader();

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();

		if ($objTicket->Load($GLOBALS['ticketid']) != -1)
		{
			$objHT = CreateObject('dcl.htmlTicketDetail');
			$objHT->Show($objTicket);
		}
		else
		{
			print('<center><h3>');
			printf(STR_TCK_COULDNOTFIND, $GLOBALS['ticketid']);
			print('</h3></center>');
			$objMy = CreateObject('dcl.htmlMyDCL');
			$objMy->showMy();
		}
	}

	function graph()
	{
		commonHeader();

		// GD is required, so short-circuit if not installed
		if (!extension_loaded('gd'))
		{
			print('<center>');
			PrintWithChocoFont(STR_BO_GRAPHNEEDSGD);
			print('</center>');
			return;
		}

		$obj = CreateObject('dcl.htmlTickets');
		$obj->DisplayGraphForm();
	}

	function showgraph()
	{
		commonHeader();

		// GD is required, so short-circuit if not installed
		if (!extension_loaded('gd'))
		{
			print('<center>');
			PrintWithChocoFont(STR_BO_GRAPHNEEDSGD);
			print('</center>');
			return;
		}

		$objG = CreateObject('dcl.boGraph');
		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$beginDate = new DCLTimestamp;
		$endDate = new DCLTimestamp;
		$testDate = new DCLTimestamp;

		$endDate->SetFromDisplay($GLOBALS['dateFrom'] . ' 23:59:59');
		$beginDate->SetFromDisplay($GLOBALS['dateFrom'] . ' 00:00:00');
		$beginDate->time -= (($GLOBALS["days"] - 1) * 86400);

		$product_id = IsSet($GLOBALS['product']) ? intval($GLOBALS['product']) : 0;
		if ($obj->LoadDatesByRange($beginDate->ToDisplay(), $endDate->ToDisplay(), $product_id) == -1)
			return;

		$objG->data[0] = array(); // Open
		$objG->data[1] = array(); // Closed

		$daysBack = array();
		$testDate->time = $beginDate->time;
		for ($i = 0; $i < $GLOBALS['days']; $i++)
		{
			$daysBack[$i] = $testDate->time;
			// Set the relevant object properties while we're at it
			$objG->line_captions_x[$i] = date('m/d', $testDate->time);
			$objG->data[0][$i] = 0;
			$objG->data[1][$i] = 0;

			$testDate->time += 86400;
		}

		while ($obj->next_record())
		{
			for ($y = 0; $y < 2; $y++)
			{
				$testDate->SetFromDB($obj->f($y));
				$j = $GLOBALS['days'] - 1;
				while ($j >= 0)
				{
					if ($testDate->time >= $daysBack[$j])
					{
						if (!IsSet($objG->data[$y][$j]))
							$objG->data[$y][$j] = 0;
						$objG->data[$y][$j]++;
						break;
					}

					$j--;
				}
			}
		}

		$objG->title = STR_BO_GRAPHTITLE;
		if ($product_id > 0)
		{
			$oDB = CreateObject('dcl.dbProducts');
			$oDB->Connect();
			if ($oDB->Load($product_id) != -1)
				$objG->title .= ' ' . $oDB->name;
		}

		$objG->caption_y = STR_BO_GRAPHCAPTIONY;
		$objG->caption_x = STR_BO_GRAPHCAPTIONX;
		$objG->num_lines_y = 15;
		$objG->num_lines_x = $GLOBALS['days'];
		$objG->colors = array('red', 'blue');

		print('<center>');
		echo '<img border="0" src="', menuLink('', 'menuAction=boGraph.Show&' . $objG->ToURL()), '">';
		print('</center>');
	}

	function reassign()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTickets');
		$obj->PrintReassignForm($objTicket);

		$objHT = CreateObject('dcl.htmlTicketDetail');
		$objHT->Show($objTicket);
	}

	function dbreassign()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($GLOBALS['ticketid']);
		if ($obj->responsible != $GLOBALS['responsible'] ||
				$obj->priority != $GLOBALS['priority'] ||
				$obj->type != $GLOBALS['type'])
		{
			$obj->responsible = $GLOBALS['responsible'];
			$obj->priority = $GLOBALS['priority'];
			$obj->type = $GLOBALS['type'];
			$obj->Edit();
			
			$objWtch = CreateObject('dcl.boWatches');
			$objWtch->sendTicketNotification($obj, '4');
		}

		$objHT = CreateObject('dcl.htmlTicketDetail');
		$objHT->Show($obj);
	}

	function upload()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTickets');
		$obj->ShowUploadFileForm($objTicket);

		$objD = CreateObject('dcl.htmlTicketDetail');
		$objD->Show($objTicket);
	}

	function doupload()
	{
		global $dcl_info, $HTTP_POST_VARS, $HTTP_GET_VARS, $HTTP_COOKIE_VARS;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		if (IsSet($GLOBALS['userfile']))
		{
			if ((IsSet($HTTP_POST_VARS['userfile']) && $HTTP_POST_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_GET_VARS['userfile']) && $HTTP_GET_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_COOKIE_VARS['userfile']) && $HTTP_COOKIE_VARS['userfile'] == $GLOBALS['userfile']))
			{
				return PrintPermissionDenied();
			}
		}

		if ($GLOBALS['userfile'] != 'none')
		{
			$o = CreateObject('dcl.boFile');
			$o->iType = ATTACHMENT_TICKET;
			$o->iKey1 = $GLOBALS['ticketid'];
			$o->sFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['name'] : $GLOBALS['userfile_name'];
			$o->sTempFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['tmp_name'] : $GLOBALS['userfile'];
			$o->sRoot = $dcl_info['DCL_FILE_PATH'] . '/attachments';
			$o->Upload();
		}

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTicketDetail');
		$obj->Show($objTicket);
	}

	function deleteattachment()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTickets');
		$obj->ShowDeleteAttachmentYesNo($GLOBALS['ticketid'], $GLOBALS['filename']);

		$objD = CreateObject('dcl.htmlTicketDetail');
		$objD->Show($objTicket);
	}

	function dodeleteattachment()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$attachPath = $dcl_info['DCL_FILE_PATH'] . '/attachments/tck/' . substr($GLOBALS['ticketid'], -1) . '/' . $GLOBALS['ticketid'] . '/';
		if (is_file($attachPath . $GLOBALS['filename']) && is_readable($attachPath . $GLOBALS['filename']))
			unlink($attachPath . $GLOBALS['filename']);

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTicketDetail');
		$obj->Show($objTicket);
	}

	function dbsearch()
	{
		commonHeader();

		global $responsible, $createdby, $closedby, $personnel, $product;
		global $type, $priority, $status, $account;
		global $createdon, $closedon, $statuson, $lastactionon;
		global $dateFrom, $dateTo, $module_id, $dcl_status_type, $department;
		global $searchText, $columns, $groups, $order, $columnhdrs;

		if (strlen($columnhdrs) > 0)
			$columnhdrs = explode(',', $columnhdrs);
		else
			$columnhdrs = array();

		if (strlen($columns) > 0)
			$columns = explode(',', $columns);
		else
			$columns = array();

		if (strlen($groups) > 0)
			$groups = explode(',', $groups);
		else
			$groups = array();

		if (strlen($order) > 0)
			$order = explode(',', $order);
		else
			$order = array();

		$objView = CreateObject('dcl.boView');
		$objView->table = 'tickets';

		if (count($personnel) > 0 || count($department) > 0)
		{
			$fieldList = array('responsible', 'createdby', 'closedby');
			$bStrippedDepartments = false;
			$pers_sel = array();
			while (list($key, $field) = each($fieldList))
			{
				if ($$field == '1')
				{
					if (count($personnel) > 0)
					{
						if (!$bStrippedDepartments)
						{
							$bStrippedDepartments = true;

							// Have actual personnel?  If so, only set personnel for their associated departments instead of the department
							// then unset the department from the array
							reset($personnel);
							while (list(, $encoded_pers) = each($personnel))
							{
								list($dpt_id, $pers_id) = explode(',', $encoded_pers);
								$pers_sel[count($pers_sel)] = $pers_id;
								if (count($department) > 0 && in_array($dpt_id, $department))
								{
									reset($department);
									while(list($key, $department_id) = each($department))
									{
										if ($department_id == $dpt_id)
										{
											unset($department[$key]);
											break;
										}
									}
								}
							}
						}

						$objView->AddDef('filter', $field, $pers_sel);
					}

					if (count($department) > 0)
						$objView->AddDef('filter', $field . '.department', $department);
				}
			}
		}

		$fieldList = array('priority', 'type', 'account');
		while (list($key, $field) = each($fieldList))
		{
			if (count($$field) > 0)
				$objView->AddDef('filter', $field, $$field);
		}

		if (count($module_id) > 0)
		{
			// Have modules?  If so, only set module IDs for their associated products instead of the product ID
			// then unset the product id from the array
			reset($module_id);
			$module = array();
			while (list(, $encoded_mod) = each($module_id))
			{
				list($mod_prod_id, $mod_id) = explode(',', $encoded_mod);
				$module[count($module)] = $mod_id;
				if (count($product) > 0 && in_array($mod_prod_id, $product))
				{
					reset($product);
					while(list($key, $product_id) = each($product))
					{
						if ($product_id == $mod_prod_id)
						{
							unset($product[$key]);
							break;
						}
					}
				}
			}

			$objView->AddDef('filter', 'module_id', $module);
		}

		if (count($product) > 0)
			$objView->AddDef('filter', 'product', $product);

		if (count($status) > 0)
		{
			// Have statuses?  If so, only set status IDs for their associated types instead of the status type ID
			// then unset the status type id from the array
			reset($status);
			$statuses = array();
			while (list(, $encoded_status) = each($status))
			{
				list($type_id, $status_id) = explode(',', $encoded_status);
				$statuses[count($statuses)] = $status_id;
				if (count($dcl_status_type) > 0 && in_array($type_id, $dcl_status_type))
				{
					reset($dcl_status_type);
					while(list($key, $status_type_id) = each($dcl_status_type))
					{
						if ($status_type_id == $type_id)
						{
							unset($dcl_status_type[$key]);
							break;
						}
					}
				}
			}

			$objView->AddDef('filter', 'status', $statuses);
		}

		if (count($dcl_status_type) > 0)
			$objView->AddDef('filter', 'statuses.dcl_status_type', $dcl_status_type);

		if ($dateFrom != '' || $dateTo != '')
		{
			if ($dateFrom != '')
				$dateFrom .= ' 00:00:00';

			if ($dateTo != '')
				$dateTo .= ' 23:59:59';

			$fieldList = array('createdon', 'closedon', 'statuson', 'lastactionon');

			while (list($key, $field) = each($fieldList))
			{
				if ($$field == '1')
					$objView->AddDef('filterdate', $field, array($dateFrom, $dateTo));
			}
		}

		if ($searchText != '')
		{
			$objView->AddDef('filterlike', 'issue', $searchText);
			$objView->AddDef('filterlike', 'summary', $searchText);
			$objView->AddDef('filterlike', 'tickets.contact', $searchText);
			$objView->AddDef('filterlike', 'contactphone', $searchText);
			$objView->AddDef('filterlike', 'contactemail', $searchText);
		}

		if (count($columns) > 0)
			$objView->AddDef('columns', '', $columns);
		else
			$objView->AddDef('columns', '',
				array('ticketid', 'responsible', 'product', 'account', 'status', 'contact', 'contactphone', 'summary'));

		if (count($groups) > 0)
		{
			reset($groups);
			while (list($key, $groupField) = each($groups))
			{
				if ($groupField == 'priorities.name')
					$groups[$key] = 'priorities.weight';
				else if ($groupField == 'severities.name')
					$groups[$key] = 'severities.weight';
			}

			$objView->AddDef('groups', '', $groups);
		}

		if (count($columnhdrs) > 0)
			$objView->AddDef('columnhdrs', '', $columnhdrs);

		if (count($order) > 0)
		{
			reset($order);
			while (list($key, $orderField) = each($order))
			{
				if ($orderField == 'priorities.name')
					$order[$key] = 'priorities.weight';
				else if ($orderField == 'severities.name')
					$order[$key] = 'severities.weight';
			}

			$objView->AddDef('order', '', $order);
		}
		else
			$objView->AddDef('order', '', array('ticketid'));


		$objView->style = 'report';

		if ($GLOBALS['title'] != '')
		{
			$o = CreateObject('dcl.dbPersonnel');
			$objView->title = $o->GPCStripSlashes($GLOBALS['title']);
		}
		else
			$objView->title = STR_TCK_TICKETSEARCHRESULTS;

		$obj = CreateObject('dcl.htmlTicketResults');
		$obj->Render($objView);
	}

	function showmy()
	{
		commonHeader();
		$obj = CreateObject('dcl.htmlTickets');
		$obj->my(0);
	}
}
?>
