/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * dc_gui2_com_channel_client.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: dc_gui2_com_channel_client.h,v 1.2 2004/01/14 15:47:10 ericprev Exp $
*/

#ifndef __DC_GUI2_COM_CHANNEL_CLIENT_H__
#define __DC_GUI2_COM_CHANNEL_CLIENT_H__

/********************************************/
/* initialize the comm channel with dc_gui2 */
/********************************************/ 
/* input: env var "EMB_IOC"             */
/* output: FALSE= EMB_IOC not available */
/*         TRUE= ok                     */
/****************************************/
gboolean init_comm_channel(void);

/* ========================================================================= */
/*****************************************************/
/* send something to the client connected to the GUI */
/*****************************************************/
void remote_send_data_to_dctc(const char *cmd);

/*****************************************************/
/* send something to the master connected to the GUI */
/*****************************************************/
void remote_send_data_to_gdl_dctc(const char *cmd);

/* ========================================================================= */
/*******************************/
/* retrieve the var of the GUI */
/***************************************/
/* output: var value (to free) or NULL */
/***************************************/
char *remote_get_var(const char *var_name);

/************************************************/
/* retrieve the value of a gtk_entry of the GUI */
/************************************************/
/* output: var value (to free) or NULL */
/***************************************/
char *remote_get_gtk_entry(const char *var_name);

/************************************************/
/* retrieve the value of a gtk_entry of the GUI */
/**********************************************************************/
/* output: var value (as an integer) or 0 if gtk_entry does not exist */
/**********************************************************************/
int remote_get_gtk_entry_as_int(const char *var_name);

/******************************************************/
/* retrieve the value of a gtk_checkbutton of the GUI */
/*************************************************************************/
/* output: var value (as a boolean) or FALSE if gtk_entry does not exist */
/*************************************************************************/
gboolean remote_get_gtk_checkbutton_as_boolean(const char *var_name);

#endif
