#!/usr/bin/env perl

# Some tests for 'darcs changes'

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;

init_tmp_repo();

my $test_name = 'record something';

`date >> date.t`;
darcs 'add date.t';

like(darcs(q(record -A 'Mark Stosberg <a@b.com>' -a -m foo date.t)), qr/finished recording/i, $test_name);

####

like(darcs(q(changes date.t)),                   qr/foo/,'changes file.txt: trivial case works');
like(darcs(q(changes --last=1 date.t)),          qr/foo/,'changes --last=1 file.txt');
like(darcs(q(changes --last=1 --summary date.t)),qr/foo/,'changes --last=1 --summary file.txt');
like(darcs(q(changes --last=1 --xml )),         qr/&lt;a\@b.com&gt;/,'changes --last=1 --xml encodes < and >');

###

# Add 50 records and try again 
for (my $i = 0; $i <= 5; $i++) {
    `date >> date.t`;
    my $out = darcs(qq(record  -a -m "foo record num $i" date.t));
    like( $out, qr/Finished record/i, "foo record num $i: success");
}

like(darcs(q(changes date.t)),                   qr/foo/,'after 50 records: changes file.txt: trivial case works');
like(darcs(q(changes --last=1 date.t)),          qr/foo/,'after 50 records: changes --last=1 file.txt');
like(darcs(q(changes --last=1 --summary date.t)),qr/foo/,'after 50 records: changes --last=1 --summary file.txt');

### 


like(darcs(q(changes --context --from-patch='num 1' --to-patch='num 4')),
     qr/^\n.*\n\n.*num 4\n.*\n\n.*num 3\n.*\n\n.*num 2\n.*\n\n.*num 1\n.*\n$/,
     'changes --context --from-patch="num 1$" --to-patch="num 4$"');

###

`date >>second_file.t`;
darcs 'add second_file.t';
like(darcs(q(record -a -m adding_second_file second_file.t)), qr/finished recording/i, 'recorded second file');
