#!/usr/bin/env perl

# Some tests for 'darcs mv'

use Test::More qw/no_plan/;
use strict;
use vars qw/$DARCS/;

die 'darcs not found' unless $ENV{DARCS} || (-x "$ENV{PWD}/../darcs");
$DARCS = $ENV{DARCS} || "$ENV{PWD}/../darcs";

`rm -rf temp1`;
`mkdir temp1`;
chdir 'temp1';
`$DARCS init`;

###

my $test_name = 'adding a directory with more than one ../ in it should work.';
`mkdir -p foo.d/second/third foo.d/other`;
`date >>foo.d/other/date.t`;
print `$DARCS add -r foo.d 2>&1`;

chdir 'foo.d/second/third';

my $mv_out = `$DARCS mv ../../other/date.t ../../other/date_moved.t 2>&1`;
unlike($mv_out, qr/darcs failed/, $test_name);

###

chdir '../../../';
`rm -rf temp1`;
ok((!-d 'temp1'), 'temp1 directory was deleted');




