/* simple password generator by Nelson Minar (minar@reed.edu)
 * copyright 1991, all rights reserved.
 * You can use this code as long as my name stays with it.
 *
 */

#include "md5crypt.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
  static char saltChars[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./";
  char salt[9];
  char plaintext[64];

  srandom(time(0));
  salt[0] = saltChars[random() % 64];
  salt[1] = saltChars[random() % 64];
  salt[2] = saltChars[random() % 64];
  salt[3] = saltChars[random() % 64];
  salt[4] = saltChars[random() % 64];
  salt[5] = saltChars[random() % 64];
  salt[6] = saltChars[random() % 64];
  salt[7] = saltChars[random() % 64];
  salt[8] = 0;

  fgets(plaintext, 64, stdin);
  plaintext[strlen(plaintext) - 1] = '\0';

  printf("%s\n", libshadow_md5_crypt(plaintext, salt));
  return 0;
}
