dnl acinclude.m4
dnl This file is copyright (C) 2001 Andrew Suffield
dnl                                  <asuffield@users.sourceforge.net>
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

dnl An attempt to induce some sanity to configure.in

AC_DEFUN(DANCER_CHECK_NBLOCK_SOCKET_POSIX,
[
AC_TRY_RUN([
#include <sys/types.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
void alarmed(int);
void alarmed(int signal)
{
	exit(1);
}
int main(void)
{
#if defined(O_NONBLOCK)
	char b[12], x[32];
	int f;
	socklen_t l = sizeof(x);
	f = socket(AF_INET, SOCK_DGRAM, 0);
	if (f >= 0 && !(fcntl(f, F_SETFL, O_NONBLOCK))) {
		signal(SIGALRM, alarmed);
		alarm(3);
		recvfrom(f, b, 12, 0, (struct sockaddr *)x, &l);
		alarm(0);
		exit(0);
	}
#endif
	exit(1);
}
], [$1],[$2],[$3])
])

AC_DEFUN(DANCER_CHECK_NBLOCK_SOCKET_BSD,
[
AC_TRY_RUN([
#include <sys/types.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
void alarmed(int);
void alarmed(int signal)
{
	exit(1);
}
int main(void)
{
#if defined( O_NDELAY ) && !defined( NBLOCK_POSIX )
	char b[12], x[32];
	int f;
	socklen_t l = sizeof(x);
	f = socket(AF_INET, SOCK_DGRAM, 0);
	if (f >= 0 && !(fcntl(f, F_SETFL, O_NDELAY))) {
		signal(SIGALRM, alarmed);
		alarm(3);
		recvfrom(f, b, 12, 0, (struct sockaddr *)x, &l);
		alarm(0);
		exit(0);
	}
#endif
	exit(1);
}
], [$1],[$2],[$3])
])

AC_DEFUN(DANCER_CHECK_NBLOCK_SOCKET_SYSV,
[
AC_TRY_RUN([
#include <sys/types.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
void alarmed(int);
void alarmed(int signal)
{
	exit(1);
}
int main(void)
{
#if !defined(NBLOCK_BSD) && !defined(NBLOCK_POSIX) && defined(FIONBIO)
	char b[12], x[32];
	int f;
	socklen_t l = sizeof(x);
	f = socket(AF_INET, SOCK_DGRAM, 0);
	if (f >= 0 && !(fcntl(f, F_SETFL, FIONBIO))) {
		signal(SIGALRM, alarmed);
		alarm(3);
		recvfrom(f, b, 12, 0, (struct sockaddr *)x, &l);
		alarm(0);
		exit(0);
	}
#endif /* !NBLOCK_POSIX && !NBLOCK_BSD && FIONBIO */
	exit(1);
}
], [$1],[$2],[$3])
])

dnl Stolen from dpkg

dnl DANCER_C_GCC_TRY_FLAGS(<warnings>,<cachevar>)
AC_DEFUN(DANCER_C_GCC_TRY_FLAGS,[
 AC_MSG_CHECKING([GCC warning flag(s) $1])
 if test "${GCC-no}" = yes
 then
  AC_CACHE_VAL($2,[
   oldcflags="${CFLAGS-}"
   CFLAGS="${CFLAGS-} ${CWARNS} $1 -Werror"
   AC_TRY_COMPILE([
#include <string.h>
#include <stdio.h>
int main(void);
],[
    strcmp("a","b"); fprintf(stdout,"test ok\n");
], [$2=yes], [$2=no])
   CFLAGS="${oldcflags}"])
  if test "x$$2" = xyes; then
   CWARNS="${CWARNS}$1 "
   AC_MSG_RESULT(ok)
  else
   $2=''
   AC_MSG_RESULT(no)
  fi
 else
  AC_MSG_RESULT(no, not using GCC)
 fi
])

dnl Almost like the one in autoconf itself

AC_DEFUN(DANCER_C_BIGENDIAN,
[AC_CACHE_CHECK(whether byte ordering is bigendian, ac_cv_c_bigendian,
[ac_cv_c_bigendian=unknown
# See if sys/param.h defines the BYTE_ORDER macro.
AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/param.h>], [
#if !BYTE_ORDER || !BIG_ENDIAN || !LITTLE_ENDIAN
 bogus endian macros
#endif], [# It does; now see whether it defined to BIG_ENDIAN or not.
AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/param.h>], [
#if BYTE_ORDER != BIG_ENDIAN
 not big endian
#endif], ac_cv_c_bigendian=yes, ac_cv_c_bigendian=no)])
if test $ac_cv_c_bigendian = unknown; then
AC_TRY_RUN([main () {
  /* Are we little or big endian?  From Harbison&Steele.  */
  union
  {
    long l;
    char c[sizeof (long)];
  } u;
  u.l = 1;
  exit (u.c[sizeof (long) - 1] == 1);
}], ac_cv_c_bigendian=no, ac_cv_c_bigendian=yes, AC_MSG_ERROR([need to know endianness when cross-compiling]))
fi])
if test $ac_cv_c_bigendian = yes; then
  AC_DEFINE(WORDS_BIGENDIAN)
fi
])

AC_DEFUN(DANCER_CHECK_LONG_LONG,
[AC_MSG_CHECKING(for long long type)
oldcflags="${CFLAGS-}"
CFLAGS="${CFLAGS-} -Werror"
AC_TRY_COMPILE([
#include <stdio.h>
int main(void);
],[
long long int x;
x = 1;
x += 1;
printf("%lld",x);
],AC_DEFINE(HAVE_LONG_LONG,,[gcc extension type long long is available]) AC_MSG_RESULT(yes), AC_MSG_RESULT(no))
CFLAGS="${oldcflags}"
])

dnl We are only interested in __attribute__(()) if it can handle %z
AC_DEFUN(DANCER_CHECK_C_ATTRIBUTE,
[AC_MSG_CHECKING([for gcc __attribute__(())])
oldcflags="${CFLAGS-}"
CFLAGS="${CFLAGS-} -Werror"
AC_TRY_COMPILE([
extern  void foo(const char *, ...)
     __attribute__((format(printf,1,2)));
int main(void);
],[
foo("%zi",sizeof(int));
],AC_DEFINE(HAVE_ATTRIBUTE,,[gcc-style attribute declarations available]) AC_MSG_RESULT(yes), AC_MSG_RESULT(no))
CFLAGS="${oldcflags}"
])
