/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.*;
import com.sap.dbtech.jdbc.exceptions.*;
import com.sap.dbtech.util.*;
/**
 *
 */
class Getval
    extends AbstractGetval
{
    boolean isBinary = false;
    /**
     * Getval constructor comment.
     */
    public Getval(
        ConnectionSapDB connection,
        byte [] descriptor,
        StructuredMem dataPart,
        int dataKind)
    {
        super (connection, descriptor, dataPart, 1);
        this.isBinary = (dataKind == com.sap.dbtech.vsp00.DataType.Dstrb);
    }
    public long length()
    throws java.sql.SQLException
    {
       return (this.lengthInBytes() / this.itemSize);
    }
    /**
     * Gets the <code>CLOB</code> value designated by this <code>Clob</code>
     * object as a stream of Ascii bytes.
     * @return an ascii stream containing the <code>CLOB</code> data
     * @exception SQLException if there is an error accessing the
     * <code>CLOB</code> value
     */
    public java.io.InputStream getAsciiStream()
        throws java.sql.SQLException
    {
        return new InputStream ();
    }
    /**
     * Retrieves the <code>BLOB</code> designated by this
     * <code>Blob</code> instance as a stream.
     * @return a stream containing the <code>BLOB</code> data
     * @exception SQLException if there is an error accessing the
     * <code>BLOB</code>
     */
    public java.io.InputStream getBinaryStream ()
        throws java.sql.SQLException
    {
        return new InputStream ();
    }
    /**
     * Gets the <code>Clob</code> contents as a Unicode stream.
     * @return a Unicode stream containing the <code>CLOB</code> data
     * @exception SQLException if there is an error accessing the
     * <code>CLOB</code>
     */
    public java.io.Reader getCharacterStream()
        throws java.sql.SQLException
    {
        return new com.sap.dbtech.util.RawByteReader(this.getAsciiStream ());
    }
    /**
     *
     */
    private class InputStream
        extends java.io.InputStream
    {
        String cachedString = null;
        /**
         * read method comment.
         */
        public int read()
        throws StreamIOException
        {
            int result;

            if (Getval.this.itemsInBuffer <= 0) {
                Getval.this.nextChunk ();
            }
            if (Getval.this.atEnd) {
                return -1;
            }
            result = Getval.this.streamBuffer.getUInt1 (0);
            Getval.this.streamBuffer.moveBase (1);
            --Getval.this.itemsInBuffer;
            ++Getval.this.longPosition;
            return result;
        }
        /**
         *
         * @return int
         * @param b byte[]
         * @param off int
         * @param len int
         * @exception StreamIOException
         */
        public  int read(byte b[], int off, int len)
        throws StreamIOException
        {
            int bytesCopied = 0;
            int chunkSize;
            byte [] chunk;

            while ((len > 0) && !Getval.this.atEnd) {
                if (Getval.this.itemsInBuffer <= 0) {
                    Getval.this.nextChunk ();
                }
                if (!Getval.this.atEnd ) {
                    /*
                     * copy bytes in buffer
                     */
                    chunkSize = java.lang.Math.min (len, Getval.this.itemsInBuffer);
                    chunk = Getval.this.streamBuffer.getBytes (0, chunkSize);
                    System.arraycopy (chunk, 0, b, off, chunkSize);
                    len -= chunkSize;
                    off += chunkSize;
                    Getval.this.itemsInBuffer -= chunkSize;
                    Getval.this.streamBuffer.moveBase (chunkSize);
                    bytesCopied += chunkSize;
                }
            }
            if ((bytesCopied == 0) && Getval.this.atEnd) {
                bytesCopied = -1;
            }
            else {
                Getval.this.longPosition += bytesCopied;
            }
            return bytesCopied;
        }
/**********************************************************************************
*   Uncomment this if you want to display LONG columns in DB Visualizer
*    or any other tool that uses getObject ().toString ()
*    instead of getString ()
*
*         /**                                                                     *
*          *                                                                      *
*          *                                                                      *
*         public String                                                           *
*         toString ()                                                             *
*         {                                                                       *
*             if (this.cachedString != null) {                                    *
*                 return this.cachedString;                                       *
*             }                                                                   *
*             java.io.StringWriter writer = new java.io.StringWriter ();          *
*             java.io.InputStreamReader reader =                                  *
*                 new java.io.InputStreamReader (this);                           *
*             char [] buf = new char [4096];                                      *
*             char [] hexBuf = null;                                              *
*             int chunkRead;                                                      *
*             boolean isBinary = Getval.this.isBinary;                            *
*             if (isBinary) {                                                     *
*                 hexBuf = new char [byesPerCharC * buf.length];                  *
*             }                                                                   *
*             try {                                                               *
*                 do {                                                            *
*                     chunkRead = reader.read (buf, 0, 4096);                     *
*                     if (chunkRead > 0) {                                        *
*                         if (isBinary) {                                         *
*                             Getval.fillHexBuf (hexBuf, buf, chunkRead);         *
*                             writer.write (hexBuf, 0, chunkRead * byesPerCharC); *
*                         }                                                       *
*                         else {                                                  *
*                             writer.write (buf, 0, chunkRead);                   *
*                         }                                                       *
*                     }                                                           *
*                 } while (chunkRead > 0);                                        *
*             }                                                                   *
*             catch (java.io.IOException exc) {                                   *
*             }                                                                   *
*             return writer.toString();                                           *
*         }                                                                       *
*     }                                                                           *
*     /**                                                                         *
*      *                                                                          *
*      *                                                                          *
*     private static final int byesPerCharC = 3;                                  *
*     static private final char [] hexDigits = {                                  *
*         '0', '1', '2', '3', '4', '5', '6', '7',                                 *
*         '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'                                  *
*     };                                                                          *
*     static private void                                                         *
*     fillHexBuf (                                                                *
*         char [] hexBuf,                                                         *
*         char [] buf,                                                            *
*         int charCount)                                                          *
*     {                                                                           *
*         for (int i = 0; i < charCount; ++i) {                                   *
*             char current = buf [i];                                             *
*             hexBuf [byesPerCharC * i]     = hexDigits [current / 16];           *
*             hexBuf [byesPerCharC * i + 1] = hexDigits [current % 16];           *
*             hexBuf [byesPerCharC * i + 2] = ' ';                                *
*         }                                                                       *
*     }                                                                           *
**********************************************************************************/
    }
}

