/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.exceptions;

import com.sap.dbtech.util.*;

/**
 *
 */
public class BatchUpdateExceptionSapDB
    extends java.sql.BatchUpdateException
{
    /**
     * BatchUpdateExceptionSapDBTech constructor comment.
     */
    public BatchUpdateExceptionSapDB() {
        super();
    }
    /**
     * BatchUpdateExceptionSapDBTech constructor comment.
     * @param updateCounts int[]
     */
    public BatchUpdateExceptionSapDB(int[] updateCounts)
    {
        super(updateCounts);
    }
    /**
     * BatchUpdateExceptionSapDBTech constructor comment.
     * @param reason java.lang.String
     * @param updateCounts int[]
     */
    public BatchUpdateExceptionSapDB(String reason, int[] updateCounts)
    {
        super(reason, updateCounts);
    }
    /**
     * BatchUpdateExceptionSapDBTech constructor comment.
     * @param reason java.lang.String
     * @param sQLState java.lang.String
     * @param updateCounts int[]
     */
    public BatchUpdateExceptionSapDB(String reason, String sQLState, int[] updateCounts)
    {
        super(reason, sQLState, updateCounts);
    }
    /**
     * BatchUpdateExceptionSapDBTech constructor comment.
     * @param reason java.lang.String
     * @param sQLState java.lang.String
     * @param vendorCode int
     * @param updateCounts int[]
     */
    public BatchUpdateExceptionSapDB(String reason, String sqlState, int vendorCode, int[] updateCounts)
    {
        super(reason, sqlState, vendorCode, updateCounts);
    }
    /**
     *
     * @param sqlExc SQLExeption
     * @param resultCountd int[]
     */
    public BatchUpdateExceptionSapDB(java.sql.SQLException sqlExc, int [] resultCounts) {
        this (sqlExc.getMessage(), sqlExc.getSQLState(), sqlExc.getErrorCode(), resultCounts);
    }

    public BatchUpdateExceptionSapDB(java.sql.SQLException sqlExc, Integer inputpos, 
                                     int [] resultCounts) {
        this (sqlExc.getMessage() + MessageTranslator.translate(MessageKey.INPUTPOS, inputpos),
              sqlExc.getSQLState(), 
              sqlExc.getErrorCode(), 
              resultCounts);
    }

    public BatchUpdateExceptionSapDB(int[] updateCounts, SQLExceptionSapDB exc)
    {
        super(exc.getMessage(),exc.getSQLState(),exc.getErrorCode(),updateCounts);
    }
}
