/* BarChartAndList.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.details;

import be.ugent.caagt.swirl.lists.TypedListModel;

import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

/**
 * Combines a bar chart and a list in a single panel.
 */
public class BarChartAndList extends JSplitPane {
    
    /**
     * Create a bar chart and list with given data model and
     * reference value.
     */
    public BarChartAndList (TypedListModel<? extends Number> dataModel, Number referenceValue) {
        super (HORIZONTAL_SPLIT);
        JList list = new JList (dataModel);
        BarChartPanel panel = 
                new BarChartPanel (dataModel, list.getSelectionModel(), referenceValue);
        setLeftComponent(new JScrollPane(list));
        setRightComponent(panel);
    }
    
    /**
     * Create a bar chart and list with given data model.
     */
    public BarChartAndList (TypedListModel<? extends Number> dataModel) {
        super (HORIZONTAL_SPLIT);
        JList list = new JList (dataModel);
        BarChartPanel panel = 
                new BarChartPanel (dataModel, list.getSelectionModel());
        setLeftComponent(new JScrollPane(list));
        setRightComponent(panel);
    }
}
