/*
 * Copyright 1999-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: ToBeImplementedProperty.java 197474 2004-03-31 10:55:07Z gmazza $ */

package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;

public class ToBeImplementedProperty extends Property {

    public static class Maker extends PropertyMaker {

        public Maker(int propId) {
            super(propId);
        }

        public Property convertProperty(Property p,
                                        PropertyList propertyList, FObj fo) {
            if (p instanceof ToBeImplementedProperty) {
                return p;
            }

            ToBeImplementedProperty val =
                new ToBeImplementedProperty(getPropId());
            return val;
        }
    }

    /**
     * Constructor
     * @param propName name of Property
     */
    public ToBeImplementedProperty(int propId) {

        //XXX: (mjg@recalldesign.com) This is a bit of a kluge, perhaps an
        //UnimplementedPropertyException or something similar should
        //get thrown here instead.

//         Log log = Hierarchy.getDefaultHierarchy().getLoggerFor("fop");
//         log.warn("property - \"" + propName
//                                + "\" is not implemented yet.");
    }
}

