/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%                                                                             %
%                            M   M   AAA    CCCC                              %
%                            MM MM  A   A  C                                  %
%                            M M M  AAAAA  C                                  %
%                            M   M  A   A  C                                  %
%                            M   M  A   A   CCCC                              %
%                                                                             %
%                  Macintosh Utility Routines for ImageMagick.                %
%                                                                             %
%                                                                             %
%                               Software Design                               %
%                                 John Cristy                                 %
%                                September 1996                               %
%                                                                             %
%                                                                             %
%  Copyright 1996 E. I. du Pont de Nemours and Company                        %
%                                                                             %
%  Permission to use, copy, modify, distribute, and sell this software and    %
%  its documentation for any purpose is hereby granted without fee,           %
%  provided that the above Copyright notice appear in all copies and that     %
%  both that Copyright notice and this permission notice appear in            %
%  supporting documentation, and that the name of E. I. du Pont de Nemours    %
%  and Company not be used in advertising or publicity pertaining to          %
%  distribution of the software without specific, written prior               %
%  permission.  E. I. du Pont de Nemours and Company makes no representations %
%  about the suitability of this software for any purpose.  It is provided    %
%  "as is" without express or implied warranty.                               %
%                                                                             %
%  E. I. du Pont de Nemours and Company disclaims all warranties with regard  %
%  to this software, including all implied warranties of merchantability      %
%  and fitness, in no event shall E. I. du Pont de Nemours and Company be     %
%  liable for any special, indirect or consequential damages or any           %
%  damages whatsoever resulting from loss of use, data or profits, whether    %
%  in an action of contract, negligence or other tortuous action, arising     %
%  out of or in connection with the use or performance of this software.      %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  The directory routines are strongly based on similiar routines written
%  by Steve Summit, scs@eskimo.com.
%
*/

#if defined(__MWERKS__)
/*
  Include declarations.
*/
#include <stdlib.h>
#include <string.h>
#include "mac.h"

/*
  Macintosh specific routines.
*/
static void Cinfostat(CInfoPBRec *pbp,struct stat *directory_info)
{
  directory_info->st_dev=pbp->hFileInfo.ioFRefNum;
  directory_info->st_ino=0;
  directory_info->st_mode=S_IREAD | (S_IREAD >> 3) | (S_IREAD >> 6);
  if (!(pbp->hFileInfo.ioFlAttrib & 01))
    directory_info->st_mode|=S_IWRITE;
  if (pbp->hFileInfo.ioFlAttrib & 0x10)
    directory_info->st_mode|=S_IFDIR;
  directory_info->st_nlink=1;
  directory_info->st_uid=0;
  directory_info->st_gid=0;
  directory_info->st_rdev=0;
  directory_info->st_size=pbp->hFileInfo.ioFlLgLen;
  directory_info->st_mtime=pbp->hFileInfo.ioFlMdDat;
  directory_info->st_atime=pbp->hFileInfo.ioFlMdDat;
  directory_info->st_ctime=pbp->hFileInfo.ioFlCrDat;
}

static DIR *OpenDirPB(CInfoPBRec *pbp)
{
  DIR
    *entry;

  int
    error;

  error=PBGetCatInfo(pbp,0);
  if (error != noErr)
    {
      errno=error;
      return((DIR *) NULL);
    }
  entry=malloc(sizeof(DIR));
  if (entry == (DIR *) NULL)
    return((DIR *) NULL);
  entry->d_VRefNum=pbp->hFileInfo.ioVRefNum;
  entry->d_DirID=pbp->hFileInfo.ioDirID;
  entry->d_index=1;
  return(entry);
}

static struct dirent *ReadDirStat(DIR *entry,struct stat *directory_info)
{
  CInfoPBRec
    pb;

  int
    error;

  static struct dirent
    dir_entry;

  static unsigned char
    pathname[2048];

  if (entry == (DIR *) NULL)
    return((struct dirent *) NULL);
  pb.hFileInfo.ioCompletion=0;
  pb.hFileInfo.ioNamePtr=pathname;
  pb.hFileInfo.ioVRefNum=0;
  pb.hFileInfo.ioFDirIndex=entry->d_index;
  pb.hFileInfo.ioDirID=entry->d_DirID;
  error=PBGetCatInfo(&pb,0);
  if (error !=noErr)
    {
      errno=error;
      return((struct dirent *) NULL);
    }
  entry->d_index++;
  (void) strcpy(dir_entry.d_name,PtoCstr(pb.hFileInfo.ioNamePtr));
  dir_entry.d_namlen=strlen(dir_entry.d_name);
  if (directory_info != (struct stat *) NULL)
    Cinfostat(&pb,directory_info);
  return(&dir_entry);
}

void closedir(DIR *entry)
{
  free((void *) entry);
}

DIR *opendir(char *path)
{
  CInfoPBRec
    pb;

  char
    pathname[2048];

  pb.hFileInfo.ioNamePtr=0;
  if ((path != (char *) NULL) || (*path != '\0'))
    if ((path[0] != '.') || (path[1] != '\0'))
      pb.hFileInfo.ioNamePtr=CtoPstr(strcpy(pathname,path));
  pb.hFileInfo.ioCompletion=0;
  pb.hFileInfo.ioVRefNum=0;
  pb.hFileInfo.ioFDirIndex=0;
  pb.hFileInfo.ioDirID=0;
  return(OpenDirPB(&pb));
}

struct dirent *readdir(DIR *entry)
{
  return(ReadDirStat(entry,(struct stat *) NULL));
}

void seekdir(DIR *entry,long position)
{
  entry->d_index=position;
}

long telldir(DIR *entry)
{
  return(entry->d_index);
}
#endif
