
/* Written by Peter Ekberg, peda@lysator.liu.se */

#include <stdlib.h>
#include <values.h>
#include <math.h>
#include "thrust.h"

word nrthings=0;
word nrsliders=0;
word nrbarriers=0;
word nrrestartpoints=0;

bullet bullets[maxbullets];
fragment fragments[maxfragments];
thing things[maxthings];
slider sliders[maxsliders];
barrier barriers[maxbarriers];
restartpoint restartpoints[maxrestartpoints];

word spacestation;
word ssx,ssy,scount;	/* Spacestation-variables */
word ssblip;

void
newslider(x,y,type)
     int x,y,type;
{
  sliders[nrsliders].x1=x;
  sliders[nrsliders].y1=y;
  sliders[nrsliders].type=type;
  sliders[nrsliders].dir=type%3;
  sliders[nrsliders].match=0;
  sliders[nrsliders].active=0;
  sliders[nrsliders++].next=NULL;
}

int
majorbutton(button)
     int button;
{
  if(((buttondata *)things[button].data)->major==-1)
    return(button);
  else
    return(((buttondata *)things[button].data)->major);
}

void
newthing(x,y,px,py,type,data)
     int x,y,px,py,type;
     void *data;
{
  int life;

  switch(type) {
  case 1:       /* Fuel */
    life=140;
    break;
  default:
    life=2;
  }
  things[nrthings].alive=life;
  things[nrthings].x=x;
  things[nrthings].y=y;
  things[nrthings].px=px;
  things[nrthings].py=py;
  things[nrthings].type=type;
  things[nrthings].data=data;
  things[nrthings++].score=0;
}

void
animatesliders(void)
{
  slider *s=sliders;
  int i;

  for(i=0; i<nrsliders; i++, s++)
    if(s->active) {
      switch(s->stage) {
      case 0:
	if(!(s->count&7)) {
	  switch(s->type) {
	  case 7:
	    writeblock(s->x1+(s->count>>3), s->y1, 121);
	    break;
	  case 8:
	    writeblock(s->x1-(s->count>>3), s->y1, 124);
	    break;
	  case 10:
	    writeblock(s->x1, s->y1+(s->count>>3), 127);
	    break;
	  case 11:
	    writeblock(s->x1, s->y1-(s->count>>3), 126);
	    break;
	  }
	}
	else if(!(s->count&3)) {
	  switch(s->type) {
	  case 7:
	    writeblock(s->x1+(s->count>>3), s->y1, 32);
	    break;
	  case 8:
	    writeblock(s->x1-(s->count>>3), s->y1, 32);
	    break;
	  case 10:
	    writeblock(s->x1, s->y1+(s->count>>3), 32);
	    break;
	  case 11:
	    writeblock(s->x1, s->y1-(s->count>>3), 32);
	    break;
	  }
	}
	s->count++;
	if(s->count >= ((abs(s->x1-s->x2)+abs(s->y1-s->y2)+1) << 3)-1) {
	  s->count=0;
	  s->stage=1;
	}
	break;
      case 1:
	s->count++;
	if(s->count>500) {
	  s->count=0;
	  s->stage=2;
	}
	break;
      case 2:
	if(!(s->count&7)) {
	  switch(s->type) {
	  case 7:
	    writeblock(s->x2-(s->count>>3), s->y1, 121);
	    break;
	  case 8:
	    writeblock(s->x2+(s->count>>3), s->y1, 124);
	    break;
	  case 10:
	    writeblock(s->x1, s->y2-(s->count>>3), 127);
	    break;
	  case 11:
	    writeblock(s->x1, s->y2+(s->count>>3), 126);
	    break;
	  }
	}
	else if(!(s->count&3)) {
	  switch(s->type) {
	  case 7:
	    writeblock(s->x2-(s->count>>3), s->y1, 112);
	    break;
	  case 8:
	    writeblock(s->x2+(s->count>>3), s->y1, 112);
	    break;
	  case 10:
	    writeblock(s->x1, s->y2-(s->count>>3), 112);
	    break;
	  case 11:
	    writeblock(s->x1, s->y2+(s->count>>3), 112);
	    break;
	  }
	}
	s->count++;
	if(s->count >= ((abs(s->x1-s->x2)+abs(s->y1-s->y2)+1) << 3)-1)
	  s->active=0;
	break;
      }
    }
}

void
startupsliders(int button)
{
  slider *s;

  s=((buttondata *)things[button].data)->sliders;

  while(s) {
    if(s->active) {
      switch(s->stage) {
      case 1:
	s->count=0;
	break;
      case 2:
	s->count=(((abs(s->x1-s->x2)+abs(s->y1-s->y2)+1) << 3)-1) - s->count-7;
	if(s->count<0)
	  s->count=0;
	s->stage=0;
	break;
      default:
	break;
      }
    }
    else {
      s->active=1;
      s->stage=0;
      s->count=0;
    }
    s=s->next;
  }
}

restartpoint *
atbarrier(word bx, word by)
{
  int i;

  for(i=0; i<nrbarriers; i++)
    if((barriers[i].x==bx) && (barriers[i].y==by))
      return(barriers[i].restart);
  return(NULL);
}

void
deletething(tp,dx,dy,sx,sy)
     thing *tp;
     int dx,dy,sx,sy;
{
  int tx,ty,i,j;

  tx=(*tp).px;
  ty=(*tp).py;
  (*tp).alive=0;

  switch((*tp).type)
    {
    case 1:		/* Fuel */
      for(i=0; i<2; i++)
	for(j=0; j<2; j++)
	  writeblock(tx+i, ty+j, 32);
      break;
    case 2:		/* Spacestation */
      spacestation=0;
      countdown=1000;
      for(i=0; i<3; i++)
	for(j=0; j<3; j++)
	  writeblock(tx+i, ty+j, 32);
      break;
    case 3:             /* Bunkers */
      writeblock(tx,   ty,   32);
      writeblock(tx+1, ty,   32);
      writeblock(tx+2, ty,   32);
      writeblock(tx+2, ty+1, 32);
      break;
    case 4:
      writeblock(tx,   ty+1, 32);
      writeblock(tx,   ty,   32);
      writeblock(tx+1, ty,   32);
      writeblock(tx+2, ty,   32);
      break;
    case 5:
      writeblock(tx,   ty+1, 32);
      writeblock(tx+1, ty+1, 32);
      writeblock(tx+2, ty+1, 32);
      writeblock(tx+2, ty,   32);
      break;
    case 6:
      writeblock(tx,   ty,   32);
      writeblock(tx,   ty+1, 32);
      writeblock(tx+1, ty+1, 32);
      writeblock(tx+2, ty+1, 32);
      break;
    }
}

void
newbullet(x,y,vx,vy,dir,owner)
     word x,y;
     int vx,vy;
     word dir;
     int owner;
{
  static word nr=0;

  bullets[nr].life=60;
  bullets[nr].x=x;
  bullets[nr].y=y;
  bullets[nr].vx=vx;
  bullets[nr].vy=vy;
  bullets[nr].dir=dir;
  bullets[nr++].owner=owner;

  if(nr==maxbullets)
    nr=0;
}

void
wrapbullets()
{
  bullet *bulletptr;
  int l;

  for(l=0, bulletptr=bullets; l<maxbullets; l++, bulletptr++)
    if((*bulletptr).life)
      (*bulletptr).y+=(PBILDY-leny3)<<3;
}

void
unwrapbullets()
{
  bullet *bulletptr;
  int l;

  for(l=0, bulletptr=bullets; l<maxbullets; l++, bulletptr++)
    if((*bulletptr).life)
      (*bulletptr).y-=PBILDY<<3;
}

void
movebullets()
{
  int l;
  bullet *bulletptr;

  for(l=0, bulletptr=bullets; l<maxbullets; l++, bulletptr++)
    if((*bulletptr).life) {
      (*bulletptr).life--;
      (*bulletptr).x=((*bulletptr).x+(lenx<<6)+
		      (*bulletptr).vx)%(lenx<<6);
      (*bulletptr).y=((*bulletptr).y+(leny<<6)+
		      (*bulletptr).vy)%(leny<<6);
    }
}

word
crashtype(type)
     word type;
{
  switch(type) {
  case 1:      /* Fuel */
  case 2:      /* Spacestation */
  case 3:      /* 3-6 Bunkers */
  case 4:
  case 5:
  case 6:
  case 7:      /* 7-8 Buttons */
  case 8:
    return(4);
  }
  return(0);
}

int
inloadcontact(x,y)
     int x,y;
{
  int dx,dy;
  int dist;
  int res=0;
  int angle;
  int sp,spr;

  dx=x-(loadbx<<3)-2;
  dy=(loadby<<3)-y+2;
  dist=dx*dx+dy*dy;
  if(dist<1024) {
    res=1-loadcontact;
  }
  else if(dist>=1024 && loadcontact) {
    loaded=1;
    if(abs(dx)<=abs(dy)) {
      if(dy>=0) {
	if(dx>=0)
	  alpha=256-arcsinus[dx];
	else
	  alpha=256+arcsinus[-dx];
      }
      else if(dx>=0)
	alpha=768+arcsinus[dx];
      else
	alpha=768-arcsinus[-dx];
    }
    else if(dy>=0) {
      if(dx>=0)
	alpha=arcsinus[dy];
      else
	alpha=512-arcsinus[dy];
    }
    else if(x>=0)
      alpha=-arcsinus[-dy];
    else
      alpha=512+arcsinus[-dy];
    angle=256-(int)(atan2(speedx,-speedy)*512/PI)-(int)alpha;
    sp=hypot(speedx,speedy);    
    deltaalpha=sp*sinus2[(angle)&1023]>>8;
    deltaalpha=min(deltaalpha,16384);
    deltaalpha=max(deltaalpha,-16384);
    spr=sp*sinus2[(angle+256)&1023]>>8;
    speedx=spr*sinus2[(alpha+256)&1023]>>9;
    speedy=-spr*sinus2[(alpha)&1023]>>9;
    loadcontact=0;
  }
  return(res);
}

int
resonablefuel(x,y,l)
     int x,y,l;
{
  thing *tp;
  int dx,dy;

  tp=&things[l];
  dx=x-(int)(*tp).x;
  dy=(int)(*tp).y-y;
  if(dx>(int)(lenx3>>1))
    dx=lenx3-dx;
  if(-dx>(int)(lenx3>>1))
    dx=-lenx3+dx;
  return(dx>-10 && dx<9 && dy>5 && dy<60);
}

int
closestfuel(x,y)
     int x,y;
{
  word i,witch=0;
  thing *thingptr;
  int dx,dy;
  int minimum=MAXINT,d;
  int hit=0;

  for(i=0, thingptr=things; i<nrthings; i++, thingptr++)
    if((*thingptr).type==1 && (*thingptr).alive>1) {
      dx=abs((int)x-(int)(*thingptr).x);
      dy=abs((int)y-(int)(*thingptr).y);
      if(dx>(lenx3>>1))
	dx-=lenx3;
      dy*=3;
      d=dx*dx+dy*dy;
      if(d<minimum) {
	minimum=d;
	witch=i;
	hit=1;
      }
    }
  return(hit?witch:-1);
}

int
closestbutton(x,y)
     int x,y;
{
  word i,witch=0;
  thing *thingptr;
  int dx,dy;
  int minimum=MAXINT,d;
  int hit=0;

  for(i=0, thingptr=things; i<nrthings; i++, thingptr++)
    if((*thingptr).type>=7 && (*thingptr).type<=8) {
      dx=abs((int)x-(int)(*thingptr).x);
      dy=abs((int)y-(int)(*thingptr).y);
      if(dx>(lenx>>1))
	dx-=lenx;
      d=dx*dx+dy*dy;
      if(d<minimum) {
	minimum=d;
	witch=i;
	hit=1;
      }
    }
  return(hit?witch:-1);
}

void
hit(x,y,crash,owner)
     word x,y,crash,owner;
{
  word i,witch=0;
  thing *thingptr;
  long dx,dy;
  long minimum=MAXLONG,d;
  int hit=0;
  int kill=1;

  for(i=0, thingptr=things; i<nrthings; i++, thingptr++)
    if((*thingptr).alive>1 && crashtype((*thingptr).type)==crash) {
      dx=(int)x-(int)(*thingptr).x;
      dy=(int)y-(int)(*thingptr).y;
      d=(long)dx*dx+(long)dy*dy;
      if(d<minimum) {
	minimum=d;
	witch=i;
	hit=1;
      }
    }
  if(hit) {
    explodething(&things[witch]);
    switch(things[witch].type) {
    case 2:
      ssblip+=10;
      if(ssblip>100)
	things[witch].alive=1;  /* Dying */
      break;
    case 7:                     /* Cannot kill buttons */
    case 8:
      startupsliders(majorbutton(witch));
      break;
    default:
      things[witch].alive=1;	/* Dying */
      break;
    }
    if(kill) {
    }
    if(owner)
      switch(things[witch].type) {
      case 1:
	things[witch].score=150;
	break;
      case 3:
      case 4:
      case 5:
      case 6:
	things[witch].score=700;
	break;
      }
  }
}

void
bunkerfirebullet(b)
     thing *b;
{
  int dir;

  dir=random()%16;
  switch((*b).type) {
  case 3:
    dir=(dir-3)&31;
    newbullet(((*b).x<<3)+14,((*b).y<<3)-68,
	      sinus[(dir+8)&31]>>3,-sinus[dir]>>3,
	      dir>>1,0);
    break;
  case 4:
    dir=(dir+3)&31;
    newbullet(((*b).x<<3)-26,((*b).y<<3)-68,
	      sinus[(dir+8)&31]>>3,-sinus[dir]>>3,
	      dir>>1,0);
    break;
  case 5:
    dir=(dir-14)&31;
    newbullet(((*b).x<<3)+14,((*b).y<<3)+44,
	      sinus[(dir+8)&31]>>3,-sinus[dir]>>3,
	      dir>>1,0);
    break;
  case 6:
    dir=(dir+12)&31;
    newbullet(((*b).x<<3)-26,((*b).y<<3)+44,
	      sinus[(dir+8)&31]>>3,-sinus[dir]>>3,
	      dir>>1,0);
    break;
  }
}

void
bunkerfirebullets()
{
  int l;
  thing *thingptr;

  for(l=0, thingptr=things; l<nrthings; l++, thingptr++)
    if((*thingptr).alive)
      if((*thingptr).type>2 && (*thingptr).type<7)
	if(!(random()%256))
	  bunkerfirebullet(thingptr);
}

int
killdyingthings()
{
  int l;
  thing *thingptr;
  int res;

  res=0;
  for(l=0, thingptr=things; l<nrthings; l++, thingptr++)
    if((*thingptr).alive==1) {
      deletething(thingptr,pblockx,pblocky,bblockx,bblocky);
      res+=(*thingptr).score;
    }

  return(res);
}

void
newfragment(x,y)
     word x,y;
{
  static word nr=0;
  int dir;
  int speed;

  dir=random()%32;
  speed=random()%48+16;
  fragments[nr].life=60;
  fragments[nr].x=x;
  fragments[nr].y=y;
  fragments[nr].vx=(speed*sinus[(dir+8)&31])>>11;
  fragments[nr++].vy=(-speed*sinus[dir])>>11;

  if(nr==maxfragments)
    nr=0;
}

void
explodething(thingptr)
     thing *thingptr;
{
  int i;

  for(i=0; i<30; i++) {
    newfragment((thingptr->x<<3)-30+random()%61,
		(thingptr->y<<3)-30+random()%61);
  }
}

void
explodeship(void)
{
  int i;

  for(i=0; i<50; i++) {
    newfragment((x+((154+shipdx)<<3)+random()%61)%(lenx3<<3),
		(y+(( 82+shipdy)<<3)+random()%61)%(leny3<<3));
    if(loaded)
      newfragment((x+((161-((252-loadpoint)*sinus2[(alpha+256)&1023])/2016)<<3)
		   +random()%61)%(lenx3<<3),
		  (y+(( 89+((252-loadpoint)*sinus2[alpha])/2016)<<3)
		   +random()%61)%(leny3<<3));
  }
}

void
wrapfragments()
{
  fragment *fragmentptr;
  int l;

  for(l=0, fragmentptr=&fragments[0]; l<maxfragments; l++, fragmentptr++)
    if((*fragmentptr).life)
      (*fragmentptr).y+=(PBILDY-leny3)<<3;
}

void
unwrapfragments()
{
  fragment *fragmentptr;
  int l;

  for(l=0, fragmentptr=&fragments[0]; l<maxfragments; l++, fragmentptr++)
    if((*fragmentptr).life)
      (*fragmentptr).y-=PBILDY<<3;
}

void
movefragments()
{
  int l;
  fragment *fragmentptr;

  for(l=0, fragmentptr=&fragments[0]; l<maxfragments; l++, fragmentptr++)
    if((*fragmentptr).life) {
      (*fragmentptr).life--;
      (*fragmentptr).x=((*fragmentptr).x+(lenx<<6)+
		      (*fragmentptr).vx)%(lenx<<6);
      (*fragmentptr).y=((*fragmentptr).y+(leny<<6)+
		      (*fragmentptr).vy)%(leny<<6);
    }
}

word
livefragments()
{
  int l;
  fragment *fragmentptr;

  for(l=0, fragmentptr=&fragments[0]; l<maxfragments; l++, fragmentptr++)
    if(fragmentptr->life)
      return(1);
  return(0);
}
