/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef LCLCTYPESX_H
# define LCLCTYPESX_H

/*
** TypeSpecification is an enum defined for each of the valid C type.
*/

typedef enum 
{
  TS_UNKNOWN, TS_VOID, TS_CHAR, TS_INT,
  TS_SIGNED, TS_UNSIGNED, TS_SHORT, TS_LONG,
  TS_FLOAT,  TS_DOUBLE, TS_ENUM, TS_STRUCT, 
  TS_UNION, TS_TYPEDEF
  } TypeSpecification;

/*
** TypeSpec is an enum for each of the valid combinations of type specifiers.
*/

typedef enum {
  TYS_NONE,				
  TYS_VOID,				
  TYS_CHAR, TYS_SCHAR, TYS_UCHAR,	
  TYS_SSINT, TYS_USINT,			
  TYS_INT, TYS_SINT, TYS_UINT,		
  TYS_SLINT, TYS_ULINT,			
  TYS_FLOAT, TYS_DOUBLE, TYS_LDOUBLE,	
  TYS_ENUM, TYS_STRUCT, TYS_UNION,	
  TYS_TYPENAME				
  } TypeSpec;

typedef bits lclctype;

extern lclctype fixBits(TypeSpecification attr, lclctype spec);
# define    fixBits(attr, spec)   ((unsigned)(1<<(attr) | (spec)))

extern lsymbol lclctype_toSort(lclctype t);
extern lsymbol lclctype_toSortDebug(lclctype t);

# else
# error "Multiple include"
# endif
