.TH XPOSTIT 1 "03 April 1996" Unix/X11R4-R6
.SH NAME
xpostit \- X window system Post-it(r) notes
.SH SYNOPSIS
.B xpostit
[
.I \-toolkitoptions ...
] [
.I \-options ...
]
.SH DESCRIPTION
.I Xpostit
provides a mechanism for manipulating on-screen Post-it(r) notes.
All six sizes of Post-it notes may be displayed,
edited,
and saved to disk files.
In addition,
any on-screen note may be resized to any arbitrary size either when it is
created or at a later time.
.PP
All notes can be "hidden" - the notes are still available but not
shown on the screen until requested by the user.  Hidden notes will
stay hidden when xpostit is exited and then restarted (as long as
the user saves all notes before exiting).
.PP
When
.I xpostit
is first invoked,
it creates a small window with a plaid background.
This is the control window for
.IR xpostit .
Additionally,
if any notes were stored in the save directory (see below),
these will be placed on the screen at their last locations,
unless they were hidden when saved (see below).
Each Post-it note,
when created,
makes another window on the screen.
.I Xpostit
is controlled using the mouse buttons and a menu.
The Post-it notes are controlled by using a drop down menu.
.SH OPTIONS
.PP
.I Xpostit
accepts all of the standard X Toolkit command line options along with the
additional options listed below.

.TP 8
.BI \-bs " number"
Specifies the size of the character buffer in which to save each Post-it
note.
A note may not contain more than this number of characters,
including newlines.
The default is 1024.

.TP 8
.BI \-nw " pixels"
Allows the user to specify the width, in pixels, for a single character of
text.  This is dependent on the font being used, but the Athena Widget set
and the Xt Intrinsics
apparently doesn't allow a program to determine this value at run time.
This value is used to determine the width of the Name dialog box, which is
used to provide a title for a given note.
The default value for this option is 10 pixels.

.TP 8
.BI \-ao " offset"
The offset is specified in pixels and is used to determine the X and Y
offsets from an anchor note for a note being cascaded.  The default value
is 15 pixels.

.TP 8
.BI \-dir " path"
Specifies the path name of the directory in which to store saved Post-it notes.
If
.I path
begins with a `/' it is taken as-is;
if it does not begin with a `/',
the path is taken relative to the home directory.
If the named directory does not already exist, then
.I xpostit
attempts to create it.
The default is
.IR \&.postitnotes .

.TP 8
.BI \-tmpdir " path"
Specifies the path name of the directory to use for temporary files.
By default ``/tmp'' is used.

.TP 8
.BI \-printcmd " cmd"
This must be a quoted command string that can be used as the format string
to sprintf().  It must include "%s" for the temporary file name used when
printing a note.  The buffer created with sprintf(), this option value, and
the temporary file name is passed to the system() call to print the note.
By default, the printcmd value is ``lpr %s''.

.TP 8
.BI \-calendarcmd " cmd"
This is the command used to produce a calendar for the current month.  On
most Unix systems this will be ``cal'', which is the default.  The output 
from this command is redirected to a temporary file and then inserted into
a note at the current cursor location.

.TP 8
.BI \-emailcmd " cmd"
The "Email" option from the notes menu will
pop up a window prompting for an email address.  The -emailcmd command
line option or .emailCmd resource can be set to your systems mailer
command.  The mailer must accept the text of the mail via standard
input (actually as a pipe from "cat tmpfile").
"cmd" must be a Unix style command in printf() format.  See the section
on \fIConfiguring the mailer\fP.

.TP 8
.B \-sb
Enables scroll-bars.
If specified,
a scroll bar will be attached to each Post-it note.

.TP 8
.B \-sv
Enables save-on-exit.
When specified,
this option tells
.I xpostit
to save all Post-it notes to disk files when exiting.
If not specified,
notes can be saved to disk files manually by the user or via the autosave
feature.
It is useful to specify this option since hidden notes cannot be saved
unless either the "Save All Notes" option is used or the autosave option
has not been disabled.  Its also to use this option since its not 
guaranteed that the autosave feature
will have saved all notes since their last updates when xpostit exits.

.TP 8
.B \-c
Enables compatibility mode.  Initially this is for notes created using
the %! magic cookie.  In version 2.2 this was changed to %%!! because
the original cookie was the one being used for Postscript files.  In 
the future this mode may cover other items that are not compatible
between versions/releases.

.TP 8
.B \-ns
Disables the autosave feature.

.TP 8
.B \-na
Disables alarms.

.TP 8
.B \-interval
Sets the timeout interval (in minutes) for when the autosave timeout should
expire.  When this timer expires, all notes are automatically saved to disk.
The default value is 10 minutes.

.TP 8
.BI \-homedir " path"
Specifies the base directory from which the File Selection Window will
look for files and directories.  If not specified, and the associated
resource 
.I .homeDir 
is not set then the environment variable 
.B HOME
is used.  If this is not set either, then the File Selection Window uses
the root (/) directory as its start point.

.TP 8
.BI \-version
Displays the current version of xpostit.

.TP 8
.B \-help
Displays a usage message.
.SH "WIDGET USAGE"
.PP
.I Xpostit
uses several widget types to construct the objects it uses.
.PP
The control window is a Plaid widget called ``Plaid''.
This is a widget designed by David A. Curry, the original author of
.I xpostit.
.PP
The menu is a pop-up shell called ``Menu'' containing a SimpleMenu widget.
From this menu the hidden notes menu can be popped up.  The hidden notes
menu is also a SimpleMenu widget.
.PP
Each Post-it note is a pop-up shell called ``PostItNote'',
containing a Form widget called ``Note''
which contains a Text widget called ``NoteText'',
and a MenuButton widget called "Options".  The Options button, when
selected, pops up a drop-down menu called "OptionsMenu" (see the Xpostit.ad
application defaults file).  Inside of this menu are 
five menu items called ``Save'', ``Erase'', ``Destroy'',
``Hide'', and ``Name''.
.PP
The confirmation box is a pop-up shell called ``Confirm'',
containing a Form widget called ``Buttons''
which contains two Command widgets called ``Confirm'' and ``Cancel''.
There is also dialog box which pops up when the Name menu item 
is selected which is called "Dialog".
.SH "RESOURCES"
.PP
.I Xpostit
understands all of the core X Toolkit resource names and classes as well
as those listed below,
which are all of class
.BR Xpostit .

.TP 8
.B \&.bufSize
Specifies the size of the character buffer used to store a Post-it note.
The default is 1024.

.TP 8
.B \&.nameWidth
See the -nw command line option.  The default value for this resource is
10.

.TP 8
.B \&.noteDir
Specifies the path name of the directory in which to store saved notes.
The default is
.IR \&.postitnotes .

.TP 8
.B \&.tmpDir
Specifies the path name of the directory to use for temporary files.
By default ``/tmp'' is used.

.TP 8
.B \&.printCmd
This must be a quoted command string that can be used as the format string
to sprintf().  It must include "%s" for the temporary file name used when
printing a note.  The buffer created with sprintf(), this option value, and
the temporary file name is passed to the system() call to print the note.
By default, the printcmd value is ``lpr %s''.

.TP 8
.B \&.calendarCmd
This is the command used to produce a calendar for the current month.  On
most Unix systems this will be ``cal'', which is the default.  The output 
from this command is redirected to a temporary file and then inserted into
a note at the current cursor location.

.TP 8
.B \&.emailCmd
The "Email" option from the notes menu will
pop up a window prompting for an email address.  The -emailcmd command
line option or .emailCmd resource can be set to your systems mailer
command.  The mailer must accept the text of the mail via standard
input (actually as a pipe from "cat tmpfile").
"cmd" must be a Unix style command in printf() format.  See the section
on \fIConfiguring the mailer\fP.

.TP 8
.B \&.saveNotes
Controls the state of the save-on-exit option.
The default is
.BR false .

.TP 8
.B \&.scrollBar
Controls placing scroll bars on Post-it notes.
The default is
.BR false .

.TP 8
.B \&.compatibility
Enables compatibility mode.  This shouldn't really be set in the 
app-defaults file.  If you wish to use this feature, use the
-c option.

.TP 8
.B \&.interval
Sets the timeout interval (in minutes) for when the autosave timeout should
expire.  When this timer expires, all notes are automatically saved to disk.

.TP 8
.B \&.anchorOffset
The offset is specified in pixels and is used to determine the X and Y
offsets from an anchor note for a note being cascaded.  The default value
is 15 pixels.

.TP 8
.B \&.noSave
If set to true then the auto-save feature is turned off.

.TP 8
.B \&.noAlarm
If set to true then the alarms feature is turned off.  This will have the
effect of graying out the ``Set Alarm'' and ``Unset Alarm'' options from
each Notes pull down menu.

.TP 8
.B \&.homeDir
Used to set the starting directory for the File Selection Window used with
the 
.IR \&Open
and
.IR \&Export
features.

.SH "ACTIONS"
.PP
It is possible to rebind the mouse buttons in the Plaid widget to perform
different functions by changing the widget's translations.  It is not
recommended that other actions (as specified in the application defaults
file) be changed, however.
The
.I raise()
action,
normally bound to the left mouse button,
raises all notes.
The
.I lower()
action,
normally bound to the middle mouse button,
lowers all notes.
The menu raising function,
normally bound to the right mouse button,
is performed by calling the actions
.I "XawPositionSimpleMenu(Menu)"
and
.IR "MenuPopup(Menu)" .
.PP
This can now be configured by changing the following lines in the
Xpostit.ad file:
.PP
Xpostit*Plaid.Translations: #replace\\n \\
.in +3
<Btn1Down>: raise()  \\n\\
.br
<Btn2Down>: lower()  \\n\\
.br
<Btn3Down>: XawPositionSimpleMenu(Menu) MenuPopup(Menu)
.in -3
.PP
to the following:
.PP
Xpostit*Plaid.Translations: #replace\\n \\
.in +3
<Btn3Down>: raise()  \\n\\
.br
<Btn2Down>: lower()  \\n\\
.br
<Btn1Down>: XawPositionSimpleMenu(Menu) MenuPopup(Menu)
.in -3
.SH "THE CONTROL WINDOW"
.PP
.I Xpostit
allows three operations to be performed from its control window.
Pressing the left mouse button in the control window will cause all Post-it
notes on the screen to be raised to the top.
Pressing the middle mouse button in the control window will cause all Post-it
notes on the screen to be lowered to the bottom.
Pressing the right mouse button in the control window raises the
.I xpostit
menu.
.SH "THE PLAID MENU"
.PP
The
.I xpostit
plaid menu provides the following selections:
.TP 8
.B "Create 1.5x2 Note"
Create a new Post-it note,
1.5 inches tall by 2 inches wide.
The window will normally need to be positioned using the window manager.
.TP 8
.B "Create 2x3 Note"
Create a new Post-it note,
2 inches tall by 3 inches wide.
.TP 8
.B "Create 3x3 Note"
Create a new Post-it note,
3 inches square.
.TP 8
.B "Create 3x4 Note"
Create a new Post-it note,
3 inches tall by 4 inches wide.
.TP 8
.B "Create 3x5 Note"
Create a new Post-it note,
3 inches tall by 5 inches wide.
.TP 8
.B "Create 4x6 Note"
Create a new Post-it note,
4 inches tall by 6 inches wide.
.TP 8
.B "Raise All Notes"
Raise all Post-it notes to the top.
This is equivalent to pressing the left mouse button in the control window.
.TP 8
.B "Lower All Notes"
Lower all Post-it notes to the bottom.
This is equivalent to pressing the middle mouse button in the control window.
.TP 8
.B "Unhide All Notes"
All notes that have been hidden will be unhidden.
.TP 8
.B "Save All Notes"
Save all Post-it notes to disk files in the save directory.
.TP 8
.B "Hidden Notes"
Pops up another menu which lists all the notes that are currently hidden.
The list contains the names of the notes so it is wise to give a note
a meaningful name (using the Name option from the pull-down menu of each
note) before it is hidden.
.TP 8
.B "Cascade Notes"
Each note can be "anchored".  If one or more 
notes are anchored and the "Cascade" option is chosen from the xpostit
menu, then all the visible notes are cascaded onto the anchored notes.  An
attempt is made to distribute all visible notes evenly amongst all the
anchored notes.  Each note also has an "unanchor" option as well.  Only
one of "anchor" or "unanchor" is sensitive for any given note.
Hidden notes are not affected by the cascade feature.
The default
offset for cascaded notes (from the anchor) is 15 pixels.  This can be 
changed with the -ao option or the .anchorOffset resource.
.TP 8
.B "Find A Note"
If you "lose" a note and want to bring it up at the cursor, select
``Find A Note'' from the plaid menu.  A pop up window of all notes will
be presented.  Select the note you want and if its not hidden it will
pop up at the cursor.  If it is hidden it will pop up in the appropriate
spot.  The ``Cancel'' button will close the pop up if no note is selected.
.TP 8
.B Exit
Exit
.I xpostit.
If the
.B \-sv
command line option was given,
or the
.B saveNotes
resource is
.B true,
all Post-it notes will be saved to disk first.
.PP
To select an item from the menu,
drag the mouse cursor to that item and release the mouse button.

.SH "THE HIDDEN NOTES MENU"
.PP
This menu pops up from the ``Hidden Notes'' option of the plaid menu.  It
functions the same as the plaid menu except the menu does not disappear
until either a menu option is selected or the label (at the top of the
menu)
is clicked on.

.SH "THE POST-IT NOTE"
.PP
Each Post-it note is made up of three parts (plus an optional scroll bar):
a Title bar,
a text window where the text of the note is stored,
and a menu bar.
.PP
The menu bar has two menus:
.I File
and
.I Notes .
The first of these contains options pertaining to file input and output,
such as Open (for importing a file to the note), Export (for saving the
text contents of the note to a file), Print and Email. 
.PP
The second menu contains items for manipulating the note:  Hiding, Naming,
Erasing, Adding a calendar or date/time stamp, etc.
.PP
To enter text into a Post-it note,
simply move the mouse cursor into the text window and start typing.
Since the text window is actually a Text widget,
all the Text widget translations are accepted.
Essentially,
this means you can use most of the \s-1EMACS\s0 control keys in the window.
Additionally,
the various mouse buttons used for manipulating the selections and cut
buffer are understood.
.PP
After entering text in the Post-it note,
you may wish to save the note in a disk file.
This way,
if the machine goes down,
or if you exit
.IR xpostit ,
the Post-it note can be restored when you restart
.IR xpostit .
(Post-it notes are also saved automatically (if
.B saveNotes
is true) if a SIGHUP,
SIGINT,
SIGTERM,
or SIGQUIT signal is received.)
To save the note to a disk file,
click on the Notes button and
drag the mouse cursor to the menu item labeled ``Save'', then release the
mouse button.
The note will be saved as the file ``note\fIn\fP'' in your save directory,
where
.I n
is some sequence number.
Note that the ``Save'' menu item will not allow you to save unless
something have been typed in the Text of the note, the name of the note
has been changed, or the text of the note has been erased.
This is a good way for
checking if you've made changes to the note.  If the Save menu item is
"insensitive" (grayed-out) then you haven't made any changes to the Text
of the note.
.BR \s-1NOTE\s0 :
it is important to remember that 
if you have disabled the auto-save (\f-sv\fP)feature then the note will not be
saved
until you have pressed the ``Save'' button.
You can also make sure changed notes get saved on exit by enabling the 
\fSave on Exit\fP feature.
.PP
To erase the entire contents of the text window,
you can 
click on the Notes button and select the ``Erase'' menu item.
This will bring up a confirmation window,
which has two buttons labeled ``Confirm'' and ``Cancel''.
If you press the ``Confirm'' button,
the text will be erased.
If you press the ``Cancel'' button,
the operation is canceled,
and nothing will happen.
.BR \s-1NOTE\s0 :
erasing the text in the window does not affect any contents of the note
you have saved on disk unless you press the ``Save'' button again.
.PP
To destroy a Post-it note,
getting rid of its window on the screen and the disk file it is saved in,
click on the Notes button and select the ``Destroy'' menu item.
This will bring up a confirmation window as described above.
If you confirm the operation,
the Post-it note will disappear from the screen and the disk file it was
saved in will be deleted.

.PP
To rename a note,
you can 
click on the Notes button and select the ``Name'' menu item.
This will bring up a dialog box,
which has two buttons labeled ``Confirm'' and ``Cancel'' as well
as a field to enter text for the new name.
If you press the ``Confirm'' button,
the new name will be placed in the title bar of the note.
If you press the ``Cancel'' button,
the operation is canceled.
.PP
To hide a note,
you can 
click on the Notes button and select the ``Hide'' menu item.
This will cause the note to disappear from the screen.  To bring the note
back, select the ``Hidden Notes'' option from the plaid pull-down menu.
Then select the note you wish to bring back up.
.BR \s-1NOTE\s0 :
The hidden notes will not stay hidden between
.IR xpostit
sessions unless you first select the "Save All Notes" option from the plaid
menu or options to save on exit (see discussion above) have been set.
.PP
To anchor a note
you can
click on the Notes button and select the ``Anchor'' menu item.
This will mark the note as an anchor note.  Anchor notes are the bottom
note, the "anchor", when the Cascade option is chosen from the xpostit
plaid menu.
.PP
To unanchor a note
you can
click on the Notes button and select the ``UnAnchor'' menu item.
This will remove the note from the list of anchor notes.
.PP
Note that only one of the ``Anchor'' or ``UnAnchor'' options will be
sensitive (allow user selection) at any time.  They are mutually exclusive
options within any give note.
.PP
To print a note, you must have configured xpostit with a valid print
command (via the -printcmd command line option or the .printCmd resource).
Select the ``Print'' option from the Notes pull down menu.  The text of the
note is printed.
.PP
To email a note use the ``Email'' option.  This 
option will
pop up a window prompting for an email address.  
Fill in the text field and select ``Accept'' to send the message.  The
notes title will be used as the subject line.  Select ``Cancel'' to cancel
sending the message.
.PP
To set a notes alarm, select ``Set Alarm'' from the notes Notes pull down
menu.  A window pops up with month, day, hour and minute fields.  Set each
of these for the day and time you wish the alarm to go off.  If you wish to
save this value between invokations you should use either the notes
``Save'' option or the ``Save All Notes'' option from the plaid windows menu.
When a notes alarm is set an icon of a clock will be visible next to the
Options menu button in the notes menu bar.
.PP
To turn off the a notes alarm, select ``Unset Alarm'' from the Notes pull
down menu.  This will disable the alarm for that note and remove the clock
icon from the menu bar.
.PP
To insert a copy of the current calendar month in the text select the
"Insert Calendar" option from the notes menu.  The text will be inserted at
the current cursor location, so you should be sure to position the cursor
first.  You can position the cursor by just clicking in the text window of
the note.
.PP
Adding the date and time is done using the "Insert Date..." option from the
notes menu.  A dialog box providing a variety of formats is presented.
Select the format desired by clicking on the small box to the left of the
format string and then click on "Accept".  The text string will be inserted
at the current cursor location.  Be sure to position the cursor prior to 
using the option.
.PP
To import a text file at the current cursor location in a note, use the
File menu's Open option.  A File Selection Window opens.  Choose a file and
select ``Accept''.  See the section on the
\fBFile Selection Window\fP for more details.
.PP
Exporting the text to a file is similar to opening a file for import.
Choose the Export option from the File pull down menu.  Select a file from
the File Selection Window.  Again, see the section on the
\fFile Selection Window\fP for more details on how to use that window.

.SH "CONFIGURING THE MAILER"
.PP
In order to use your systems mailer with the Email feature of xpostit, you
need to configure the appropriate mailer command using either the -emailcmd
command line option or the .emailCmd resource.   The format for both of
these is the same:  a double-quoted string which contains the name of the
mailer command, the option for providing the subject line, and the
addressee.  By default the Unix command "mail" is used.  It is defined in
the Xpostit.ad (and in the source code fallback resources) as:
.sp 2
.in +10
"mail -s\\"%s\\" %s"  
.in -10
.sp 2
The format is the standard format used by printf().  The first string 
parameter is the subject line.   The backslashes are required so that the
following double quotes are passed properly to the shell.  If these are
left out the subject will be truncated to the first word of the first
string parameter and an attempt will be made by the mailer to send mail to
non-existant recipients. 
.PP
The second string is the addressee.  The order of
the string parameters
is required (subject first, addressee second).  The mailer command
accpets the text of the mail via standard input.  This too is required.
.PP
If you use elm, you might want to change this to:
.sp 2
.in +10
"elm -s\\"%s\\" %s > /dev/null"
.in -10
.sp 2
The difference here is that elm prints out a few messages when it runs in
batch mode and you should send those to /dev/null.

.SH "USING THE FILE SELECTION WINDOW"
.PP
The File Selection Window contains two scrollable windows, a text input
field, and two buttons.  The scrollable windows contain the directories
(the left-side scrollable window) and the files (the right-side scrollable
window) in the current directory.  These windows may not be the same size
if the number of directories or files isn't enough to stretch the window to
its maximum size before it allows scrolling (ie don't report the windows
being different sizes as a bug - its a feature).  You can scroll the
windows the same way you scroll the text of the notes.  
.PP
The buttons inside
the scrollable windows only require a single click to activate them.
Clicking on a directory button will close the File Selection Window and
reopen it using the new directory as its base.  The scrollable windows will
be updated to reflect the files and directories in that directory and
the text input field will be updated to show the current directory.
.PP
Clicking on a button in the files scrollable window will cause that file to
be selected.  If you are opening a file then the file chosen will be added
to the current note at the location of the cursor in that note.  Be sure to
set the cursor to where you want to import text before opening a file.  If
you are exporting a file then the text of the file will be written to the
file chosen.  It is assumed that since you manually selected a file known
to exist that you want to overwrite that file, so be sure you know what
you're doing before you click on a file for exporting!
.PP
The text input field can be used to manually type a directory or file name.
If the name typed is a directory, the File Selection Window is closed and a
new one opened using the new directory as the base.  If the name typed is a
file then that filename is used for the current task, either opening or
exporting.  If exporting, and the file exists, a window is popped up asking
for confirmation to overwrite that file.  Click on ``Accept'' to proceed
with the export or ``Cancel'' to skip it.
.PP
The two buttons in the File Selection window are the ``Accept'' and
``Cancel'' buttons.  The Cancel button closes the File Selection Window
with no further actions taken.  The Accept button only has meaning in
relation to the text input field.  If you click on Accept, then whatever is
in the text input field is used as the filename for the current task (open
or export) and the appropriate action is taken.

.SH "SEE ALSO"
X(1)
.SH BUGS
.PP
The sizes of the Post-it notes are only as accurate as the display
dimension and resolution returned by the server.
On the Sun server and possibly others,
this means they aren't all that accurate.
.PP
On Linux systems the word wrap feature of the Text Widget appears broken.
The words get wrapped to the next line but they do not get erased from the
previous line.  I'm not sure how to fix this.  You can resize the note
using the window manager to clear the problem, or scroll the note window.
.PP
The message: ``Warning: XtRemoveGrab asked to remove a widget not on the
list'' may be written to stdout after an alarm popup is dismissed.  This is 
a timing
issue in the X libs, I think, and doesn't appear to cause any problems.
.PP
The Dialog used to name a note doesn't limit the number of characters that
can be used in a name, although it does prevent (by use of translations)
a user from putting a newline in the text.  The drawback to not limiting
the length of the name is that the dialog box's text field won't resize or
scroll to the right as characters are typed off the right hand edge of the
field.  Bummer dude.  This might be fixable if key events force a resize on
each keystroke.  Hmmm.  I'll have to think about that one.
.PP
The -c option has been reported to not read in old notes properly.  It eats
the first line.  This can be worked around by adding a blank line to the
old notes.  However, I couldn't reproduce this problem.  I suggest creating
a backup of your old notes before trying to run with the -c option, just in
case.
.PP
Hidden notes have their shell x and y coordinates set to 1 less than the
note originally had them set to when the program starts.  I think this is 
either a problem with the
way fvwm was placing the notes when they were visible (with window manager
borders) or a problem with the X libs.  Probably fvwm.  In anycase, over
time, the notes will slowly move toward the upper left, but only while
invisible.  When you pop them up, things are fine.  Basically, its not
something worth fixing.
.PP
On some systems (all?), specifically Solaris, setting the num-lock on 
prevents the pull-down menus from allowing the user to select 
menu options.  The fix:  turn off numlock.
.PP
The File Selection Window is not graceful, but its functional.  I could
have used the FWF FileSelection widget, but that required including the 
complete FWF kit, which I didn't want to have to do.  Besides, I think I
may switch this to GTK (the GIMP Toolkit widget set) for the next release.
Maybe.
.PP
Without a color display for canary yellow notes and red plaid,
the aesthetic value of
.I xpostit
cannot be fully appreciated.
.SH AUTHOR
Originally by David A. Curry, SRI International,
but the majority of features and the current look of the notes
are the responsibility of
Michael J. Hammel (mjhammel@csn.net).
.sp
``Post-it'' and the plaid design are registered trademarks of 3M.
