#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Xsqldefs.h"

void WriteFieldLines(FD_Shower *fd_Shw, Info_t *I)
{
   char buffer[MAXSTRING];
   char *type;
   int x;

   fl_freeze_form(fd_Shw->Shower);
   
   sprintf(buffer,"%18s %18s %8s %8s %12s %8s","Fieldname","Tablename",
	   "Length","Type","Unique Key","Not Null");
   fl_add_browser_line(fd_Shw->Browser,buffer);
   
   for(x=0;x < I->Allflds;x++)
   {
      switch(I->Fields[x].type)
      {
       case CHAR_TYPE: type = "Character"; break;
       case TEXT_TYPE: type = "Free text"; break;
       case INT_TYPE : type = "Integer";   break;
       case REAL_TYPE: type = "Real";      break;
       case IDX_TYPE : type = "Index";     break;
       default:
	 Message("Unknown fieldtype detected !");
	 type = "Unknown"; break;
      }
      
      sprintf(buffer,"@C%c%18s %18s %6d   %10s %8s %8s",
	      x == I->Primkey ? '1' : '0', /* primary key color */
	      I->Fields[x].name,
	      I->Table,I->Fields[x].length,
	      type,IS_UNIQUE(I->Fields[x].flags) ? "Y" : "N",
	      IS_NOT_NULL(I->Fields[x].flags) ? "Y" : "N"
	      );
      
      fl_add_browser_line(fd_Shw->Browser,buffer);
   }
   fl_unfreeze_form(fd_Shw->Shower);
}

void SetPrimaryKey(FL_OBJECT *ob, long parent) /* callback */
{
   FD_Shower *fd_Shw = (FD_Shower *)parent;
   Info_t *I = (Info_t *)fd_Shw->ldata;
   int linenr;
   
   if((linenr = fl_get_browser(fd_Shw->Browser)) < 2)
     return; /* no selection made or headerline selected */
   
   if(I == NULL)
   {
      Message("Info struct is NULL !!");
      return;
   }
   if(I->Fields[linenr - 2].type == IDX_TYPE)
   {  
      Message("Can't use an index as primary key !");
      return;
   }
      
   I->Primkey = linenr - 2; /* also counts header line ! */
   fl_clear_browser(fd_Shw->Browser);
   WriteFieldLines(fd_Shw,I);
}

int GetPrimaryKey(Info_t *I)
{
   m_result *indexes;
   char *primkeyname;
   int y;
   
   for(y=0;y<I->Allflds;y++)
   {
      if(IS_UNIQUE(I->Fields[y].flags))
	break;
   }
   
   if(y>=I->Allflds)
   {
      Message("No unique indexes found for this table: "
	      "using first field as the primary key.\n"
	      "You can set the primary key in the Field Info window.");
      return 0;
   }
   
   /* if more than one field is used for an index : exit with error */ 
   /* if more than one unique index : exit with error */

   indexes = msqlListIndex(sock,I->Table,I->Fields[y].name);
   
   msqlDataSeek(indexes,1); /* number 1 is the index type  ! */
   primkeyname = *msqlFetchRow(indexes);

   for(y=0;y<I->Numflds;y++)
   {
      if(strncmp(I->Fields[y].name,primkeyname,strlen(I->Fields[y].name)) == 0)
	break;
   }
   if(y >= I->Numflds)
   {
      Message("No unique primary key field found for this table !");
      y=0;
   }
   
   msqlFreeResult(indexes);
   return y;
}

void XsqlFieldInfo(FL_OBJECT *ob, long parent)
{
   FD_Xsql *Xsql = (FD_Xsql *)parent;
   Info_t  *I    = (Info_t *) Xsql->vdata;
   FD_Shower *fd_Shw;
   
   if(CheckTableSelected(Xsql) < 0)
     return;
   
   fd_Shw = BuildShowerForm(I,"Field descriptions",KEYFIELD);
   
   WriteFieldLines(fd_Shw,I);
}
