function [txtdo]=lmitool(PROBNAME,XNAME,DNAME) 
[LHS,RHS]=argn(0);
txtdo=[]

if RHS ~=3 then
x_message(['Welcome to LMITOOL';'      ';'   ';
    'LMITOOL is a Scilab package for LMI optimization';
      '            ';
      '           ';
      'It can solve the following problem';
      '                 ';
      '   minimize  f(X1,...,XM)  ';
      'subject to the LME constraints: ';
      '   Gi(X1,...,XM)=0,  i=1,2,...,p,';
      'and the LMI constraints:  ';
      '   Hj(X1,...,XM)>=0,  j=1,2,...,q.';
      '              ';
      'where';
      'X1,...,XM are unknown real matrices, referred to as the unknown matrices,';
      'f is the objective function, a linear scalar function of the entries of the X''s,';
      'Gi''s are affine matrix functions of the entries of the X''s,';
      'Hj''s are affine symmetric matrix functions of the entries of the X''s.';
      '            ';
      'These functions are parameterized by the entries of known data matrices D1,...,DN.';
      '        ';
      'For a detailed description and examples consult: ';
      '          ''LMITOOL: a Package for LMI Optimization in Scilab, User''s Guide'' ';
      '          ';
      'LMITOOL uses Semidefinite Programming package SP developed by L. Vandenberghe and S. Boyd.'])




  PROBNAME1='foo';
  XNAME1='X1,X2,...';
  DNAME1='D1,D2,...';

  if RHS==1 then
    tt=read(PROBNAME,-1,1,'(a)');
    tt=stripblanks(tt);
    mat=str2vec(tt);
    [q1,p1]=find(mat'=='[');
        [q2,p2]=find(mat'==']');
    XNAME1=mat(p1(1),q1(1)+1:q2(1)-1);
    XNAME1=strcat(XNAME1);
    [q1,p1]=find(mat'=='(');
    [q2,p2]=find(mat'==')');
    DNAME1=mat(p1(1),q1(1)+1:q2(1)-1);
    DNAME1=strcat(DNAME1);
    [q2,p2]=find(mat'=='=');
    PROBNAME1=mat(p2(1),q2(1)+1:q1(1)-1);
    PROBNAME1=strcat(PROBNAME1);
  end

  labels=['LMI problem name: ';'Names of unknown matrices: ';...
          'Names of data matrices: '];
  [ok,PROBNAME,XNAME,DNAME]=getvalue(['Problem definition';
      'LMITOOL will generate for you a skeleton of the functions needed';
        ' (see User''s Guide for details). For that, you need to specify:';
          '1- Name of you problem which will be given to the solver function,';
          '2- Names of unknown matrices or list of unknown matrices,';
          '3- Names of data matrices or list of data matrices.'],labels,...
          list('str',1,'str',1,'str',1),...
          [PROBNAME1+'            ',XNAME1+'           ',DNAME1+'         ']);
      if ok=%f then 
        txtdo='Try again';return;
      end
    end      
    PROBNAME=stripblanks(PROBNAME);
    XNAME=stripblanks(XNAME);
    DNAME=stripblanks(DNAME);


      pathname=unix_g('pwd');
      fname = pathname+'/'+PROBNAME+'.sci';
      Today=unix_g('date');
 
      txt0='function ['+XNAME+']='+PROBNAME+'('+DNAME+')'
      txt0=[txt0;'/'+'/ Generated by lmitool on '+Today;'  '];

      txt0=[txt0;
          '  Mbound = 1e3;';
          '  abstol = 1e-10;';
          '  nu = 10;';
          '  maxiters = 100;';
          '  reltol = 1e-10;';
          '  options=[Mbound,abstol,nu,maxiters,reltol];'
          '   ']

      nv=length(XNAME);
      index_commas=[];
      for k=1:nv
        if part(XNAME,k)==',' then index_commas=[index_commas,k],end
      end
      vnum = length(index_commas)+1;
      index_commas = [0 index_commas length(XNAME)+1];

      txt1=[];txt2=[];
      for i = 1:vnum,
        vname = part(XNAME,index_commas(i)+1:index_commas(i+1)-1);
        if RHS<>1 then  
          txt1 = [txt1;
              vname+'_init=...']
        end
        txt2=[txt2,vname+'_init'];
      end



      txts1=['function [LME,LMI,OBJ]='+PROBNAME+'_eval(XLIST)';
          '['+XNAME+']=XLIST(:)']
      if RHS ~= 1 then
        txts2=['LME=...';'LMI=...';'OBJ=...']
      else
        [p,q]=size(mat);
        ind=[]
        for i=1:p
          if mat(i,2:7)==['/','/','/','/','/','/']  then
            ind=[ind i];
          end
        end
        if prod(size(ind))<>4 then 
          error('File not generated by lmitool or badly modified');
        end
        txt1=[];
        for i=ind(1)+1:ind(2)-1
          txt1=[txt1;strcat(mat(i,:))];
        end
        txts2=[];
        for i=ind(4)+1:p
          txts2=[txts2;strcat(mat(i,:))];
        end
      end

      sep11=['/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'...
              +'/'+'DEFINE INITIAL GUESS AND PRELIMINARY CALCULATIONS BELOW']
      sep12=['/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'...
              +'/'+' ']
      sep13=['/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'...
              +'/'+'DEFINE LME, LMI and OBJ BELOW']

      sep2=['/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'...
              +'/'+'EVALUATION FUNCTION'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/'+'/']

      txt2=[
          'XLIST0=list('+strcat(txt2,',')+')';
          'XLIST=lmisolver(XLIST0,'+PROBNAME+'_eval,options)';
          '['+XNAME+']=XLIST(:)'];

      txt4=[txt0;sep11;txt1;sep12;' ';txt2;' ';' ';' ';...
              sep2;' ';txts1;' ';sep13;txts2];

      if RHS==0|RHS==1 then
        [txt4]=x_dialog(['Function definitions';
            'Here is a skeleton of the functions which you shoud edit';
            'You can do the editing in this window or click on ''ok'', save';
              'the skeleton and edit later using your favorite editor'],[txt4]);
        end
      if txt4=[] then txtdo='Try again';return;end
        txt=[txt4];
        n=1;
        if RHS<>3 then

          fname=x_dialog(['Name of file in which you want the solver function';
              'and the evaluation function be saved (overwrites if a';
              'file with the same name exists already)'],[fname+'                '])
          fname=stripblanks(fname);
        else
          x_message('functions saved in '+fname');
        end
        if fname<>[] then
          unix_s('\rm -f '+fname);
          write(fname,txt)
        else
          return
        end

        // tell user what to do:
        if RHS==0|RHS==1 then
          txtdo = ['    To solve your problem, you need to ';
              '1- load (and compile) your functions using the command:';
              '   getf('''+fname'+''',''c'')';
              '2- Define '+DNAME+' and call function '+PROBNAME+' as follows:';
              '  '+'['+XNAME+']='+PROBNAME+'('+DNAME+')';
              '           Good luck! ';
              'To check the result, use [LME,LMI,OBJ]='+PROBNAME+'_eval(list('+XNAME+'))']
          
          x_message(txtdo);return
        end
        if RHS==3 then
          txtdo = ['    To solve your problem, you need to ';
              '1- edit file '+fname
              '2- load (and compile) your functions:';
              '   getf('''+fname'+''',''c'')';
              '3- Define '+DNAME+' and call '+PROBNAME+' function:';
              '  '+'['+XNAME+']='+PROBNAME+'('+DNAME+')';
              'To check the result, use [LME,LMI,OBJ]='+PROBNAME+'_eval(list('+XNAME+'))']
        end

function [vec]=str2vec(str)
w=length(str);
[p,q]=size(w);ma=max(w);
vec=[];
for i=1:ma
  vec=[vec part(str,i)]
end

function txt=stripblanks(txt)
// stripblanks - strips leading and trailing blanks of strings
//%SYNTAX
// txt=stripblanks(txt)
//%PARAMETERS
// txt : string or matrix of strings
//%DESCRIPTION
// stripblanks strips leading and trailing blanks of strings
//!
[m,n]=size(txt)
for l=1:m
  for k=1:n
    t=txt(l,k)
    l2=length(t)
    while l2>0 then
      if part(t,l2)==' ' then l2=l2-1,else break,end //trailing blanks
    end
    l1=1
    while l1<l2 then
      if part(t,l1)==' ' then l1=l1+1,else break,end //leading blanks
    end
    txt(l,k)=part(t,l1:l2)
  end
end

 
