# check for MANPATH in various places
# set manx(MANPATH0), maybe add to warnings

set manx(manpathset-warnings) ""
proc manManpathSet {} {
	global manx env

	set manx(manpathset-warnings) ""
	set ws "\[ \t\]"; set nws "\[^ \t\]"

	# if user has MANPATH set, use it
	if {![info exists env(MANPATH)] || $env(MANPATH)==""} {
		set manpath ""; set manpathsrc ""; set def [string trim $manx(manpathdef)]

		# using GNU's gmanpath?
		if ![catch {set gmanpath [exec gmanpath -q]}] {
			set manpathsrc "given by gmanpath"
			set manpath $gmanpath


		# BSDI: locations of man pages stored in "man.conf"
		} elseif {[file readable [set manconf "/etc/man.conf"]]} {
			set manpathsrc "read from $manconf"
			set manpathlist {}

			set fid [open $manconf]
			while {![eof $fid]} {
				gets $fid line
				if {[regexp "^_default$ws+(.*)" $line all dirs]
					|| [regexp "^\[a-zA-Z\]$nws*$ws+($nws+)\$" $line all dirs]} {
					set onoff [string match "_default*" $line]
					foreach globdir $dirs {
						set hassubdirs [string match "*/" $globdir]
#puts "checking $globdir, onoff=$onoff, hassubdirs=$hassubdirs"
						foreach dir [glob -nocomplain [string trimright $globdir "/"]] {
							if {!$hassubdirs} {
								if {![string match "*/man" $dir]} {set dir [file dirname $dir]}
								if {![string match "*/man" $dir]} continue
							}
							if {[lsearch $manpathlist $dir]==-1} {
								lappend manpathlist $dir
								if {![info exists man($dir)]} {set man($dir) $onoff}
								append manpath "$dir:"
							}
						}
					}
				}
			}
			close $fid


		# Linux: locations of man pages stored in "man.config"?
		} elseif {[file readable [set manconf "/etc/man.config"]] || [file readable [set manconf "/etc/manpath.config"]]} {
			set manpathsrc "read from $manconf"
			set manpathlist ""

			set fid [open $manconf]
			while {![eof $fid]} {
				gets $fid line
				if {[regexp "^(MANDATORY_)?MANPATH$ws+($nws+)" $line all junk man]} {
					append manpath ":$man"; lappend manpathlist $man
				} elseif {[regexp "^MANPATH_MAP$ws+($nws+)$ws+($nws+)" all bin man]} {
					if {[lsearch $manx(bin-paths) $bin]!=-1 && [lsearch $manpathlist $man]==-1} {
						append manpath ":$man"; lappend manpathlist $man
					}
				}
			}
			close $fid


		# SCO has /etc/default/man
		} elseif {[file readable [set manconf "/etc/default/man"]]} {
			set fid [open $manconf]
			while {![eof $fid]} {
				if {[regexp "^\[ \t]*MANPATH\[ \t]*=\[ \t]*(.*)" [gets $fid] all tmp]} {
					regsub "scohelp:" $tmp "" man
					# take last MANPATH= line so don't break
				}
			}
			close $fid

			set manpathsrc "set to system default in $manconf"
			set manpath $man

		# on an SGI, go with its default
		} elseif {[file readable /usr/catman] || [file readable /usr/share/catman]} {
			set manpathsrc "set to the IRIX default"
			set manpath "/usr/share/catman:/usr/share/man:/usr/catman:/usr/man"


		# set to Makefile's default setting
		} elseif {$def!=""} {
			set manpathsrc "set to local default"
			set manpath $def


		# calculate MANPATH from PATH -- your seventh--eighth if you count env(MANPATH)--and final chance
		# (if no MANPATH and no PATH set initially, MANPATH set to /usr/local/man:/usr/man)
		} else {
			set manpathsrc "calculated from your PATH"

			foreach i $manx(bin-paths) {
				if {$i==""} continue
				if [regexp {(.*)/bin(/.*)?} $i all dirtop] {
					set i $dirtop/man
					if {[manPathCheckDir $i]==""} {
						append manpath "$i:"
					}
				}
			}
		}


		# all alternative settings finally set MANPATH here
		set manpath [string trim $manpath ":"]
		set env(MANPATH) $manpath

		regsub -all ":" $manpath ":\n    " manpathshow
		append manx(manpathset-warnings) "You don't have a MANPATH environment variable set, but you should.\n"
		append manx(manpathset-warnings) "Assuming a MANPATH, $manpathsrc, of:\n    $manpathshow\n\n"
	}

	set manx(MANPATH0) $env(MANPATH)
DEBUG {puts stderr "env(MANPATH) => $env(MANPATH)"}
}


# check validity of MANPATH and set manx(paths)

set manx(manpath-warnings) ""
proc manManpathCheck {} {
	global man manx env

	set manx(manpath-warnings) ""
	set manx(paths) {}
	set manpatherr ""
	set whatiserr 0
	set glimpseerr 0
	set glimpseuptodate 1
	set pass 0
	set homeman $env(HOME)/man
	set needmyman [expr {[file readable $homeman] && [llength [glob -nocomplain $homeman]]>0}]

	# would like to generate validity information for whatis, but
	# if it does exist, then that's OK (it's BSDI) and if it
	# doesn't that's OK (it's got a good whatis organization)

	# BSDI concatenates all whatis information into single file
	# share fBSDI with manualpage.tcl to find xxx.0 files
	set manx(fBSDI) [file readable [set whatis "/usr/share/man/whatis.db"]]
	set fDebian [expr {[file readable [set whatis "/usr/man/index.bt"]] || [file readable [set whatis "/var/catman/index.bt"]]}]
	# HPUX concatenates all whatis information into single file
	set fHPUX 0; if {!$manx(fBSDI) && !$fDebian} { set fHPUX [file readable [set whatis "/usr/lib/whatis"]] }


	foreach root [split $manx(MANPATH0) ":"] {
		# canonicalize path
		# not a general solution, but expand some abbreviations
		if {$root=="." || [string match "./*" $root] || [string match "../*" $root]} {
			# could expand relative paths, but that's not a good fit with the database ... maybe reconsider now ... no, people start TkMan from wherever and it wouldn't make sense to sometimes have extra paths
			append manpatherr "$root ignored -- relative paths are incompatible\n"
			continue
		}
#		if {$root=="."} {set $root [pwd]}
		if [string match "~*" $root] {set root [glob -nocomplain $root]}
		if {[string trim $root]==""} continue

		if {[string match "/?*/" $root ]} {
			append manpatherr "$root -- spurious trailing slash character (\"/\")\n"
			# clean this one up and keep on going
			set root [string trimright $root "/"]
		}

		if {$root==$homeman} {set needmyman 0}

		# validate
		if {$root=="/"} {
			append manpatherr "$root -- root directory not allowed\n"
		} elseif {[lsearch $manx(paths) $root]>=0} {
			append manpatherr "$root -- duplicated path\n"
		} elseif {[set tmp [manPathCheckDir $root]]!=""} {
			append manpatherr $tmp
		} elseif {![string match "*/catman" $root] && [glob -nocomplain $root/$manx(subdirs)]==""} {
			# if nothing in that directory, something's probably wrong
			append manpatherr "$root -- no subdirectories matching $manx(subdirs) glob pattern\n"
			# directory too specific: a subdirectory?
			if {![string match "*/man" $root] && [glob -nocomplain "[file dirname $root]/$manx(subdirs)"]!=""} {
				append manpatherr "    => try changing it to [file dirname $root]\n"
			# or not specific enough?
			} elseif {[file exists $root/man]} {
				append manpatherr "    => try changing it to $root/man\n"
			}

		# valid directory, check whatis, glimpse
		} else {
			# directory looks good, add it to list of valids
			lappend manx(paths) $root
			if {![info exists man($root)]} {set man($root) 1}
			lappend manx(pathstat) $man($root)
			set manx($root,latest) [lfirst [manLatestMan $root]]

			# check for apropos index (called windex on Solaris)
			if {!$manx(fBSDI) && !$fDebian && !$fHPUX} {
				if ![file exists [set whatis $root/windex]] {
					set whatis $root/whatis
				}
			}

			if {![file exists $whatis]} {
				append manpatherr "$root -- no `whatis' file for apropos\n"
				if {!$whatiserr} {
					append manpatherr "    => generate `whatis' with mkwhatis/makewhatis/catman\n"
					set whatiserr 1
				}
			} elseif {![file readable $whatis]} {
				# whatis set above
				append manpatherr "$whatis not readable\n"
			} elseif {[file mtime $whatis]<$manx($root,latest)} {
				append manpatherr "$whatis out of date\n"
			}

			# now check for Glimpse files
			if {$man(glimpse)!=""} {
				set g $root; if {$man(indexglimpse)!="distributed"} {set g $man(glimpsestrays)}
				set gi $g/.glimpse_index

				if {$man(indexglimpse)=="distributed" || $pass==0} {
					if {[glob -nocomplain $g/.glimpse*]==""} {
						append manpatherr "$g -- no Glimpse support\n"
						if {!$glimpseerr} {
							append manpatherr "    => try building Glimpse database (under Occasionals)\n"
							set glimpseerr 1; set glimpseuptodate 0
						}
					} elseif {![file readable $gi]} {
						append manpatherr "$g -- Glimpse index exists but not readable\n"
					}
				}

				if {[file readable $gi] && [file mtime $gi]<$manx($root,latest)} {
						append manpatherr "$root -- Glimpse index out of date\n"
				}
			}
		}

		incr pass
	}

	if $needmyman {append manpatherr "~/man -- not in MANPATH, which is unusual\n"}
	if {$manpatherr!=""} {
		append manx(manpath-warnings) "Problems in paths of MANPATH environment variable...\n" $manpatherr "\n"
	}

	if ![llength $manx(paths)] {
		puts stderr "NO VALID DIRECTORIES IN MANPATH!\a"
		exit 1
	}
}

proc manPathCheckDir {dir} {
	set warning ""

	if {![file exists $dir]} {
		set warning "doesn't exist"
	} elseif {![file isdirectory $dir]} {
		set warning "not a directory"
	} elseif {![file readable $dir]} {
		set warning "not readable\n    => check permissions"
	} elseif {![file executable $dir]} {
		set warning "not searchable (executable)\n    => check permissions"
	} elseif {[glob -nocomplain $dir/*]==""} {
		set warning "is empty"
	}

	if {$warning!=""} {set warning "$dir -- $warning\n"}
	return $warning
}
