/*
  Optimizer
  GAS header file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#ifndef _GAS_H_
#define _GAS_H_

#include "Global.h"
#include "Holder.h"
#include "Entry.h"
#include "IdEntry.h"
#include "optimizer.tab.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <string.h>

//
//	Method name : loadFile
//
//	Description : Loads the source-file into a buffer
//	Input : ---
//	Output : ---
//
void Holder::loadFile(void) {
 char str[MaxSize];
 extern FILE *yyin;
 YYSTYPE tmp; 

 rewind(yyin);
 while (!feof(yyin)) {
   strcpy(str,"");
   fgets(str,MaxSize-1,yyin);
   strcpy(tmp.label,str);
   tmp.flag = LABEL;
   this->insert(&tmp);
 }
}

//
//	Method name : saveFile
//
//	Description : Saves the buffer to the dest-file
//	Input : ---
//	Output : ---
//
void Holder::saveFile(void) {
  PEntry tmp;
  extern FILE *yyout;

  fputs("// Optimizer v", yyout);
  fputs(VERSION, yyout);
  fputs(" generated file\n\n", yyout);
  tmp = this->firstEntry;
  while (tmp != NULL) {
    fputs(tmp->getlabel(), yyout);
    tmp = tmp->next;
  }
}

//
//	Method name : GASoptP5
//
//	Description : Optimize to Pentium
//	Input : ---
//	Output : ---
//
void Holder::GASoptP5(void){

}


//
//	Method name : GASoptP6
//
//	Description : Optimize to Pentium Pro
//	Input : ---
//	Output : ---
//
void Holder::GASoptP6(void){

}


//
//	Method name : GASoptMMX
//
//	Description : Optimize with MMX support
//	Input : ---
//	Output : ---
//
void Holder::GASoptMMX(void){

}



#endif
