/*
 * chos loader module definitions file.
 *
 * Copyright (c) Tuomo Valkonen 1997.
 */
#ifndef __CHOS_MODULE_H
#define __CHOS_MODULE_H

#include "address.h"

// Functions address table
#define FN_TABLE	FN_TABLE_OFF
#define print		FN_TABLE
#define print_period	FN_TABLE+2
#define crlf		FN_TABLE+4
#define get_cmdline	FN_TABLE+6
#define tell_loading	FN_TABLE+8
#define load_1st_sector	FN_TABLE+10
#define load_next_map	FN_TABLE+12
#define load_map	FN_TABLE+14
#define read_linear	FN_TABLE+16
#define load_it		FN_TABLE+18
#define toupper		FN_TABLE+20
#define putch		FN_TABLE+22
#define end_load	FN_TABLE+24
#define reset_drive	FN_TABLE+26
#define write_linear	FN_TABLE+28

// Variable address table
#define VAR_TABLE	write_linear+2
#define image		VAR_TABLE
#define ask_cmdline	VAR_TABLE+2
#define drive		VAR_TABLE+4
#define load_high	VAR_TABLE+6
#define secno		VAR_TABLE+8
#define copy_gdt	VAR_TABLE+10
#define copy_src	copy_gdt+16
#define copy_src_base	copy_src+2
#define copy_dst	copy_src_base+6
#define copy_dst_base	copy_dst+2
#define copy_dst_base24 copy_dst_base+5

// Had to do this manually - I couldn't figure out a way to 
// do this with as86: it always generated
// 'call +x', 'callf far *x' or an error :(
// Well, using this macro is easier anyway...

#define CALL(x)		.word 0x16ff,x	// call *(x) / call near [x]
			
#endif