

#include <stdlib.h>
#include <stdio.h>
#include <proplist.h>
#include <string.h>

#include "../src/wconfig.h"

/* table of style related options */
static char *options[] = {
    "IconBack",
    "WorkspaceBack",
    "IconBack",	
    "TitleJustify",	
    "WindowTitleFont",	
    "MenuTitleFont",	
    "MenuTextFont",	
    "IconTitleFont",	
    "FiendTitleFont",
    "DisplayFont",	
    "HighlightColor",	
    "HighlightTextColor",
    "FiendTitleColor",
    "CFiendTitleColor",
    "AFiendColor",
    "IFiendColor",
    "FTitleColor",	
    "PTitleColor",	
    "UTitleColor",	
    "FTitleBack",	
    "PTitleBack",	
    "UTitleBack",	
    "MenuTitleColor",	
    "MenuTextColor",	
    "MenuDisabledColor", 
    "MenuTitleBack",	
    "MenuTextBack",	
};




char *ProgName;


char*
defaultsPathForDomain(char *domain)
{
    char path[1024];
    char *gspath, *tmp;

    gspath = getenv("GNUSTEP_USER_ROOT");
    if (gspath) {
	strcpy(path, gspath);
	strcat(path, "/");
    } else {
	char *home;
	
	home = getenv("HOME");
	if (!home) {
	    printf("%s:could not get HOME environment variable!\n", ProgName);
	    exit(0);
	}
	strcpy(path, home);
	strcat(path, "/GNUstep/");
    }
    strcat(path, DEFAULTS_DIR);
    strcat(path, "/");
    strcat(path, domain);

    tmp = malloc(strlen(path)+2);
    strcpy(tmp, path);
    
    return tmp;
}


int 
main(int argc, char **argv)
{
    proplist_t prop, style, key, val;
    char *path;
    int i;

    
    ProgName = argv[0];
    
    if (argc>2 || (argc==2 && strcmp(argv[1], "-h")==0)) {
	printf("Syntax:\n%s [<style file>]\n", argv[0]);
	exit(1);
    }
    
    path = defaultsPathForDomain("WindowMaker");
    
    prop = PLGetProplistWithPath(path);
    if (!prop) {
	printf("%s:could not load WindowMaker configuration file \"%s\".\n", 
	       ProgName, path);
	exit(1);
    }

    style = PLMakeDictionaryFromEntries(NULL, NULL, NULL);
    
    
    for (i=0; options[i]!=NULL; i++) {
	key = PLMakeString(options[i]);
	
	val = PLGetDictionaryEntry(prop, key);
	if (val)
	    PLInsertDictionaryEntry(style, key, val);
    }
    

    if (argc==2) {
	val = PLMakeString(argv[1]);
	PLSetFilename(style, val);
	PLSave(style, NO);
    } else {
	puts(PLGetDescriptionIndent(style, 0));
    }
    exit(0);
}


