/* winspector.h - window attribute inspector header file
 * 
 *  WindowMaker window manager
 * 
 *  Copyright (c) 1997 Alfredo K. Kojima
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef WINSPECTOR_H_
#define WINSPECTOR_H_

#include "window.h"

typedef struct InspectorPanel {
    struct InspectorPanel *nextPtr;

    WWindow *frame;

    WWindow *inspected;       /* the window that's being inspected */

    WMWindow *win;

    /* common stuff */
    WMButton *revertBtn;
    WMButton *applyBtn;
    WMButton *saveBtn;

    WMButton *pageBtn1;
    WMButton *pageBtn2;
    WMButton *pageBtn3;
    WMButton *pageBtn4;

    /* first page. general stuff */
    
    WMFrame *specFrm;
    WMButton *instRb;
    WMButton *clsRb;
    WMButton *bothRb;
    WMButton *defaultRb;

    WMLabel *specLbl;
    
    /* second page. attributes */
    
    WMFrame *attrFrm;
    WMButton *attrChk[9];
    
    /* 3rd page. more attributes */
    WMFrame *moreFrm;
    WMButton *moreChk[7];
    
    
    /* 4th page. icon and workspace */
    WMFrame *iconFrm;
    WMLabel *iconLbl;
    WMLabel *fileLbl;
    WMTextField *fileText;
    WMButton *alwChk;
    WMButton *updateIconBtn;
    WMButton *defaultIconBtn;
    
    WMFrame *wsFrm;
    WMButton *curRb;
    WMButton *setRb;
    WMTextField *wsText;
    
} InspectorPanel;

void wShowInspectorForWindow(WWindow *wwin);
void wDestroyInspectorPanels();

#endif
