/*
 *  WindowMaker miscelaneous function library
 * 
 *  Copyright (c) 1997 Alfredo K. Kojima
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef WMLIB_H_
#define WMLIB_H_

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>

#include <assert.h>

#ifdef WMAKER
# ifndef WMCONFIG_H_
#  include "../wconfig.h"
# endif
#endif

#if HAVE_LIBINTL_H && I18N
# include <libintl.h>
# define _(text) gettext(text)
#else
# define _(text) (text)
#endif


#include "hashtable.h"
#include "list.h"

/* max size for a line buffer */
#define MAXLINE	1024
/* max size for a path name */
#define MAXPATH 512


#define SETFLAG(var, flag)  (var)|=(flag)

#define CLRFLAG(var, flag)  (var)&=~(flag)

#define CKFLAG(var,flag)   ((var)&(flag))

extern char *ProgName;

void wFatal(const char *msg, ...);
void wWarning(const char *msg, ...);
void wSysError(const char *msg, ...);
void wFormatXError(Display *dpy, XErrorEvent *error, char *buffer, int size);

void wRequestSelection(Display *dpy, Window requestor, Time timestamp);

char *wGetSelection(Display *dpy, Window requestor);


char *find_file(char *paths, char *file);

char *find_file_in_list(char **path_list, char *file);

char *gethomedir();

void *xmalloc(size_t size);
void *xrealloc(void *ptr, size_t newsize);

#define wmalloc(size) xmalloc(size)
#define wrealloc(ptr,size) xrealloc(ptr,size)



/*
 * Compatibility stuff
 */
#ifndef HAVE_STRDUP
#define strdup(txt)    ((txt) ? strcpy(wmalloc(strlen(txt)+1), (txt)) : NULL)
#endif


#define wmsleep(x) usleep(x)


#endif
