/***************************************
  $Header: /home/amb/wwwoffle/RCS/wwwoffle.h 2.33 1998/02/26 20:04:44 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.1.
  A header file for all of the programs wwwoffle, wwwoffled.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97,98 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef WWWOFFLE_H
#define WWWOFFLE_H    /*+ To stop multiple inclusions. +*/


/* ------------------------------------------------------------
   The values in the section below can be changed if required, see INSTALL. */

/*+ The default port number to use for the http proxy demon. +*/
#define DEF_HTTP_PORT 8080

/*+ The default port number to use for the wwwoffle control. +*/
#define DEF_WWWOFFLE_PORT 8081

/*+ The default spool directory. +*/
#define DEF_SPOOL "/var/spool/wwwoffle"

/*+ The default configuration file directory. +*/
#define DEF_CONF "/var/spool/wwwoffle"

/*+ The default age of pages in days before purging. +*/
#define DEF_PURGE_AGE 14

/*+ The absolute maximum number of servers to fork in total. +*/
#define MAX_SERVERS 64
/*+ The default total number of servers to fork. +*/
#define DEF_MAX_SERVERS 8

/*+ The absolute maximum number of servers to fork for fetching previously requested pages. +*/
#define MAX_FETCH_SERVERS 48
/*+ The default number of servers to fork for fetching pages. +*/
#define DEF_MAX_FETCH_SERVERS 4

/*+ The time in seconds to wait while reading from a socket. +*/
#define SOCKET_TIMEOUT 120

/* The values in the section above can be changed if required, see INSTALL.
   ------------------------------------------------------------ */

#include "misc.h"

/* In connect.c */

void CommandConnect(int client);
void ForkServer(int client,int browser);

/* In purge.c */

void PurgeCache(int fd);

/* In spool.c */

int OpenOutgoingSpoolFile(int rw);
void CloseOutgoingSpoolFile(int fd,URL *Url);
int ExistsOutgoingSpoolFile(URL *Url);
char *HashOutgoingSpoolFile(URL *Url);
char *DeleteOutgoingSpoolFile(URL *Url);

int OpenWebpageSpoolFile(int rw,URL *Url);
char *DeleteWebpageSpoolFile(URL *Url,int all);
void TouchWebpageSpoolFile(URL *Url);
int ExistsWebpageSpoolFile(URL *Url);

void CreateBackupWebpageSpoolFile(URL *Url,int fd);
void RestoreBackupWebpageSpoolFile(URL *Url);
void DeleteBackupWebpageSpoolFile(URL *Url);

char *DeleteLastTimeSpoolFile(URL *Url);
int CreateLastTimeSpoolFile(URL *Url);

int OpenMonitorSpoolFile(URL *Url);
char *DeleteMonitorSpoolFile(URL *Url);

char *FileNameToURL(char *file);
char *URLToFileName(URL *Url);

/* In parse.c */

char *ParseRequest(int fd,char **request_head,char **request_body);

int RequestChanges(int fd,char **request_head);
char *MovedLocation(URL *Url,char *reply_head);
char *RequestURL(char *url,char *referer);

char *ModifyRequest(URL *Url,char *request_head);

char *MakeRequestAuthorised(char *proxy,char *request_head);
char *MakeRequestNonProxy(char *request_head);

int ParseReply(URL *Url,char **reply_head);

/* In messages.c */

void ServerError(int fd,char *string);
void RemoteHostError(int fd,URL *Url,char *reason,int cache,int backup);
void CantRefreshPosted(int fd,URL *Url);
void WillGetURL(int fd,URL *Url,int already);
void RefreshRedirect(int fd,URL *Url);
void WelcomePage(int fd);
void IllegalPage(int fd,char *pathargs);
void PasswordDisallowed(int fd,URL *Url);
void IllegalProto(int fd,char *url,char *proto);
void NotModified(int fd);
void RefusedRequest(int fd,URL *Url);

/* In index.c */

void IndexPage(int fd,char *path,char *args);

/* In control.c */

void ControlPage(int fd,char *path,char *args,char *request_head,char *request_body);

/* In configedit.c */

void ConfigEditPage(int fd,char *args,char *request_body);

/* In refresh.c */

char *RefreshPage(int fd,char *path,char *args,char *url,char *request,int is_online);

/* In monitor.c */

void MonitorPage(int fd,char *path,char *args,char *request_body);
void RequestMonitoredPages(void);

/* In html.c (html.l) */

int ParseHTML(int fd,URL *Url,int html);
char **ListImages(void);
char **ListLinks(void);
char **ListFrames(void);
char *MetaRefresh(void);
int GetHTMLEnd(void);

/* In wwwoffles.c */

int wwwoffles(int online,int browser,int client);

#endif /* WWWOFFLE_H */
