// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tifs.h
// 
// Purpose:     
// 
// Created:     26 Jan 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tifs.h,v 1.6 1997/02/24 15:56:28 jfasch Exp $
// 
// $Log: tifs.h,v $
// Revision 1.6  1997/02/24 15:56:28  jfasch
// declared a smartpointer
//
// Revision 1.5  1997/02/24 12:32:20  jfasch
// just comments
//
// Revision 1.4  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// Revision 1.3  1997/02/12 20:27:30  jfasch
// some header file movings
//
// Revision 1.2  1997/02/12 20:27:11  jfasch
// singleton (instance)
//
// Revision 1.1  1997/02/04 13:48:16  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tifs_h
#define hg_dispatch_tifs_h

#include "tif.h"

#include <hyperg/utils/deque_t.h>
#include <hyperg/utils/verbose.h>

Dequedeclare (TIOINETFactoriesBase, TIOINETFactoryPtr) ;

class TIOINETFactories : public TIOINETFactory, public TIOINETFactoriesBase {
public:
   TIOINETFactories() : running_(false) {}
   virtual ~TIOINETFactories() ;

   virtual void start() ;
   virtual void stop() ;

   virtual TIOINETResponsePtr connect (const TIOINETRequestPtr&) ;

   static TIOINETFactories& instance() ;
   // setting an instance requires explicit start()ing it. however, if
   // there was an instance already set, it is implicitly stopped (and
   // deleted) on setting a new one.
   static void instance (TIOINETFactories*) ;

private:
   virtual void do_cancel_(const TIOINETRequest*) ;

private:
   // just to assert I am running when a request comes along, and I am
   // stopped on destruction (paranoia)
   bool running_ ;

   static TIOINETFactories* instance_ ;

protected:
   TIOINETFactories (const TIOINETFactories&) {}
   TIOINETFactories operator = (const TIOINETFactories&) { return *this; }

public:
   static Verbose verbose ;
   // link time assertion
   static const char* version1 ;
} ;
static const char* TIOINETFactories_version = TIOINETFactories::version1 ;

SmartPtrdeclare (TIOINETFactoriesPtr, TIOINETFactories) ;

#endif
