<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook.dsl SYSTEM "/usr/lib/sgml/docbook/html/docbook.dsl" CDATA DSSSL>
<!ENTITY html-common.dsl SYSTEM "html-common.dsl">
<!ENTITY common.dsl SYSTEM "common.dsl">
]>

<!--

  $Id: phpweb.dsl,v 1.18 1998/04/27 12:35:49 ssb Exp $

  HTML-specific stylesheet customization for use by the online manual.

-->

<style-specification id="docbook-php-website" use="docbook">

(declare-flow-object-class processing-instruction
  "UNREGISTERED::James Clark//Flow Object Class::processing-instruction")

(define %html-ext% ".php3")

(define (phpweb-quote str)
  (string-replace str "'" "\\'"))

(define (phpweb-header #!optional (nd (current-node)))
    (php3-code
     (string-append
      newline
      "require('shared-manual.inc'); " newline
      (phpweb-header-navigation nd) newline
      "manualHeader('" (phpweb-quote (phpweb-node-title nd)) "');" newline)))

(define (phpweb-footer #!optional (nd (current-node)))
  (php3-code
   (string-append
    "manualFooter('" (phpweb-quote (phpweb-node-title nd)) "');")))

(define (phpweb-node-title #!optional (nd (current-node)) (title-elem "TITLE"))
  (let* ((preferred-title-node
	  (cond ((equal? (gi nd) "REFENTRY")
		 (node-list-first
		  (select-elements
		   (children
		    (select-elements (children nd) "REFNAMEDIV"))
		   "REFNAME")))
		(else
		 (node-list-first
		  (select-elements (children nd) title-elem)))))
	 (title-node
	  (if (node-list-empty? preferred-title-node)
	      (select-elements (children nd) "TITLE") ;; fallback
	      preferred-title-node)))
    (data title-node)))
	       
(define (phpweb-header-nav-array nd)
  (let ((href (href-to nd))
	(title (phpweb-quote (phpweb-node-title nd "TITLEABBREV"))))
    (string-append
     "array('" href "', '" title "')")))
   
(define (phpweb-node-list-map func ndl)
  (let* ((node (node-list-first ndl))
	 (rest (node-list-rest ndl))
	 (item (func node)))
    (if (node-list-empty? rest)
	(list item)
	(append (list item) (phpweb-node-list-map func rest)))))

(define (phpweb-header-navigation nd)
  (let ((prev (prev-chunk-element nd))
	(next (next-chunk-element nd))
	(up (parent nd))
	(home (sgml-root-element))
	(toc-nodes (siblings (chunk-parent nd))))
    (string-append
     "setupNavigation(array(" newline
     "  'home' => " (phpweb-header-nav-array home) "," newline
     "  'prev' => " (phpweb-header-nav-array prev) "," newline
     "  'next' => " (phpweb-header-nav-array next) "," newline
     "  'up'   => " (phpweb-header-nav-array up) "," newline
     "  'toc'  => array(" newline
     (join 
      (phpweb-node-list-map (lambda (nnl)
			      (string-append
			       "    "
			       (phpweb-header-nav-array nnl)))
			    toc-nodes)
      (string-append "," newline))
     ")));")))
    
(define (html-document title-sosofo body-sosofo)
  (let ((doc-sosofo 
	 (if (or (chunk?) (node-list=? (current-node) (sgml-root-element)))
	     (make sequence
		   (phpweb-header (current-node))
		   body-sosofo
		   (phpweb-footer (current-node)))
	     body-sosofo)))
    (if (chunk?)
	(make entity
	      system-id: (html-file)
	      doc-sosofo)
	doc-sosofo)))

&html-common.dsl;
&common.dsl;

</style-specification>

<external-specification id="docbook" document="docbook.dsl">
<!--
Local Variables:
mode: scheme
End:
-->
