/* -*-Mode: C;-*-
 * XDELTA - RCS replacement and delta generator
 * Copyright (C) 1997  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: cm.c 1.20.1.2.1.1 Sun, 12 Oct 1997 20:29:34 -0700 jmacd $
 */

#include "xdelta.h"

void
match_level_free (MatchLevel *match_level)
{
  if (match_level)
    {
      g_mem_chunk_destroy (match_level->chunk);
      g_slist_free (match_level->to_intervals);
      g_free (match_level);
    }
}

static void
lookup_helper (MatchQuery    *query,
	       CKList        *cksum,
	       MatchLevel    *match_level,
	       gint           buffer_index,
	       gint           segment_len,
	       gint           lower_limit,
	       gint           upper_limit)
{
  gint to_index = buffer_index - segment_len;
  gint is_match;
  Match match;

  is_match = (* query->grow_match) (query,
				    cksum,
				    segment_len,
				    lower_limit,
				    upper_limit,
				    to_index,
				    &match);

  if (!is_match)
    {
#ifdef DEBUG_HASH
      match_level->false_alarms += 1;
#endif
      return;
    }

  match_level->match = g_chunk_new (Match, match_level->chunk);

  *match_level->match = match;

  match_level->to_intervals = g_slist_prepend (match_level->to_intervals,
					       match_level->match);

#ifdef DEBUG_HASH
  match_level->matches_width += match.length;
#endif
}

static gint
lookup_checksum (MatchQuery    *query,
		 MatchLevel    *match_level,
		 ChecksumTable *table,
		 gint           buffer_index,
		 gint           segment_len,
		 Checksum      *cksum,
		 gint           lower_limit,
		 gint           upper_limit)
{
  CKList *lu = c_hash_table_lookup (table, cksum);

  match_level->match = NULL;

  for (; lu && !match_level->match; lu = lu->next)
    {
      Checksum* lck = lu->cksum;

      if (cksum->high == lck->high && cksum->low  == lck->low)
	lookup_helper (query, lu, match_level, buffer_index,
		       segment_len, lower_limit, upper_limit);
    }

  return match_level->match ?
         match_level->match->to_high :
         -1;
}

/* Find matches for checksums computed for WIDTH atoms matching
 * against the to buffer from LOW to HIGH.
 */
#define CHEW(x)   (single_hash[(guint)x])
#define INITCKSUM init_checksum_1
#define FMNAME    find_matches_1
#define LHNAME    lookup_helper_1
#define ACCESS    ob
#include "cm.cn"
#undef ACCESS
#undef CHEW
#undef INITCKSUM
#undef FMNAME
#undef LHNAME

#define CHEW(x)   (x)
#define INITCKSUM init_checksum_2
#define FMNAME    find_matches_2
#define LHNAME    lookup_helper_2
#define ACCESS    tb
#include "cm.cn"
#undef ACCESS
#undef CHEW
#undef INITCKSUM
#undef FMNAME
#undef LHNAME
