/* libdpkg - Debian packaging suite library routines
 * dpkg-db.h - declarations for in-core package database management
 *
 * renamed to vercmp.h and hack to shreds for the purposes of quinn
 * diff
 *
 * Copyright (C) 1994,1995 Ian Jackson <iwj10@cus.cam.ac.uk>
 * Copyright (C) 1997 James Troup <jjtroup@comp.brad.ac.uk>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with dpkg; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include "hash.h"

struct versionrevision {
  unsigned long epoch;
  char *version, *revision;
};  

#define MIN_PRIORITY_LENGTH 10
#define MIN_SECTION_LENGTH  15

int versioncompare(const struct versionrevision *version,
                   const struct versionrevision *refversion);

const char *parseversion(struct versionrevision *rversion, const char *string);

void compare_versions (char *d_version_string, 
		       struct package_info *hashed_package_info);
