#!@@PERL@@
#
#     Copyright (C) 1997 Claus-Justus Heine
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
#      This script implements a simple contents listing for the zftape
#      package using the MTIOCVOLINFO ioctl.  For use with the
#      QIC-40/80/3010/3020 floppy-tape driver "ftape" for Linux.
#

$version = <<EOT;
listtape-1.0 -- a perl script to list the contents of a floppy tape cartridge
under Linux using the zftape driver

RCS \$Revision: 1.2 $null
RCS \$Date: 1997/10/28 14:22:57 $null
EOT

$tapedev = $ENV{'TAPE'} || "/dev/tape";
$usage = <<EOT;
Usage: listtape [options ...]

Mandatory or optional arguments to long options are mandatory or optional
for short options too.

  -f, --file FILE       Tape device to use. Default is  "/dev/tape".
  -h, --help            Print this help.
  -?                    Same as '-h'.
      --usage           Same as '-h'.
  -V, --version         Print version information.

Author: Claus-Justus Heine <claus\@momo.math.rwth-aachen.de>
EOT

while ($ARGV[0] =~ /^-/) { 
    $_ = shift; 
    if (/--file/) {$_ = shift; $tapedev = $_; next;} 
    if (/-f/) {$_ = shift; $tapedev = $_; next;} 
    if (/--help/) { print $usage; exit 0; }
    if (/-h/) { print $usage; exit 0; }
    if (/--usage/) { print $usage; exit 0; }
    if (/-\?/) { print $usage; exit 0; }
    if (/--version/) { print $version; exit 0; }
    if (/-V/) { print $version; exit 0; }
    die $usage;
}

&open_tape($tapedev, "status");
while(<FTMT>)
{
    $online = 1 if (/.*online.*/);
}

if (! $online) { die "No cartridge present.\n"; }

&mtop($tapedev, "rewind");

printf "%11s%12s%20s%20s\n",
    "file number", "block size", "volume size", "tape space";

while (1)
{
    &open_tape($tapedev, "volinfo");
    while (<FTMT>) {
	if (/^file number\s*=\s*([0-9]*)$/) { $filenumber = $1; }
	if (/^block size\s*=\s*([0-9]*)$/) { $blocksize = $1; }
	if (/^physical space used\s*=\s*([[0-9]*.*)/) { $rawsize = $1; }
	if (/^real size of volume\s*=\s*([[0-9]*.*)/) { $size = $1; }
    }
    close(FTMT);
    if (&mtop($tapedev, "fsf 1") != 0) {
	&mtop($tapedev,"rewind");
	print "\nRemaining space: $rawsize\n";
	print "Tape block size: $blocksize\n";
	exit 0;
    }	    
    printf "%6d          %5d  %20s%20s\n",
	    $filenumber, $blocksize, $size, $rawsize;
}

sub mtop
{
    local ($tape, $operation) = @_;
    local ($exitval);
    system "ftmt -f $tape $operation > /dev/null 2>&1";
}

sub open_tape
{
    local ($tape, $operation) = @_;
    local ($command);

    $command = "ftmt -f " . $tape . " " . $operation . " |";
    open(FTMT, $command) || die "Couldn't open $command -- $!\n";
}
