.TH BONNIE 1 "2 September 96"
.SH NAME
bonnie \- Unix filesystem performance benchmark
.SH SYNOPSIS
\fBbonnie\fP [ -d scratch-dir ] [ -s size-in-Mb ] [ -m machine-label ]\fP
.SH OPTIONS
.TP 
\fB-d scratch-dir\fP
Directory to create working file in. Filesystem must be large enough to
accomodate the size of the working file.
.TP
\fB-s size-in-Mb\fP
Size of the working file in megabytes. Defaults size is 100 megabytes. The
larger the better.
.TP
\fB-m machine-label\fP
Identifying label to use for the machine benchmark is being run on.
.SH DESCRIPTION
\fBbonnie\fP is a file system benchmark which attempts to study bottlenecks -
it is named 'Bonnie' for semi-obvious reasons.

Specifically, these are the types of filesystem activity that have been
observed to be bottlenecks in I/O-intensive applications, in particular
the text database work done in connection with the New Oxford English
Dictionary Project at the University of Waterloo.
 
It performs a series of tests on a file of known size.  By default, that
size is 100 Mb (but that's not enough - see below).  For each test, Bonnie 
reports the bytes processed per elapsed second, per CPU second, and the 
% CPU usage (user and system).
 
In each case, an attempt is made to keep optimizers from noticing it's 
all bogus.  The idea is to make sure that these are real transfers to/from
user space to the physical disk.  The tests are:
 
1. Sequential Output

1.1 Per-Character.  The file is written using the putc() stdio macro.
The loop that does the writing should be small enough to fit into any
reasonable I-cache.  The CPU overhead here is that required to do the
stdio code plus the OS file space allocation.
 
1.2 Block.  The file is created using write(2).  The CPU overhead
should be just the OS file space allocation.
 
1.3 Rewrite.  Each BUFSIZ of the file is read with read(2), dirtied, and
rewritten with write(2), requiring an lseek(2).  Since no space
allocation is done, and the I/O is well-localized, this should test the
effectiveness of the filesystem cache and the speed of data transfer.
 
2. Sequential Input
 
2.1 Per-Character.  The file is read using the getc() stdio macro.  Once
again, the inner loop is small.  This should exercise only stdio and
sequential input.
 
2.2 Block.  The file is read using read(2).  This should be a very pure
test of sequential input performance.
 
3. Random Seeks
 
This test runs SeekProcCount processes in parallel, doing a total of
4000 lseek()s to locations in the file specified by random() in bsd systems,
drand48() on sysV systems.  In each case, the block is read with read(2).  
In 10% of cases, it is dirtied and written back with write(2).

The idea behind the SeekProcCount processes is to make sure there's always 
a seek queued up.
 
AXIOM: For any unix filesystem, the effective number of lseek(2) calls
per second declines asymptotically to near 30, once the effect of
caching is defeated.

The size of the file has a strong nonlinear effect on the results of
this test.  Many Unix systems that have the memory available will make
aggressive efforts to cache the whole thing, and report random I/O rates
in the thousands per second, which is ridiculous.  As an extreme
example, an IBM RISC 6000 with 64 Mb of memory reported 3,722 per second
on a 50 Mb file.  Some have argued that bypassing the cache is artificial
since the cache is just doing what it's designed to.  True, but in any 
application that requires rapid random access to file(s) significantly
larger than main memory which is running on a system which is doing
significant other work, the caches will inevitably max out.  There is
a hard limit hiding behind the cache which has been observed by the
author to be of significant import in many situations - what we are trying
to do here is measure that number.
.SH COPYRIGHT
Copyright (c) Tim Bray, 1990.
Everybody is hereby granted rights to use, copy, and modify this program, 
provided only that this copyright notice and the disclaimer below
are preserved without change.

DISCLAIMER:
This program is provided AS IS with no warranty of any kind, and
The author makes no representation with respect to the adequacy of this
program for any particular purpose or with respect to its adequacy to 
produce any particular result, and
The author shall not be liable for loss or damage arising out of
the use of this program regardless of how sustained, and
In no event shall the author be liable for special, direct, indirect
or consequential damage, loss, costs or fees or expenses of any
nature or kind.
.SH BUGS
None known
.SH AUTHOR
Tim Bray <tbray@watsol.waterloo.edu>
