#include <unistd.h>
#include <fcntl.h>
#include <math.h>
#include <errno.h>
#include <x_types.h>
#include "backup.h"

#ifndef XOR
#define XOR(a,b)	(((a) & ~(b)) | (~(a) & (b)))
#endif

#define	PI_1_8		(M_PI / 8.0)
#define	PI_3_8		(M_PI / 8.0 * 3.0)
#define	S_PI_1_8	sin(PI_1_8)
#define	S_PI_3_8	sin(PI_3_8)

#define	LOG_8		log(8.0)
#define	LOG_12		log(12.0)

static Uns32	accesskey = ACCESSKEY;

Int32
set_cryptkey(UChar * filename)
{
  struct stat	statb;
  Int32	i, fd;
  Uns32	n;
  UChar		buf[10];

  i = stat(filename, &statb);
  if(i)
    return(ENOENT);

  fd = open(filename, O_RDONLY);
  if(fd < 0)
    return(EACCES);

  i = read(fd, buf, 5);
  close(fd);

  if(i < 5)
    return(EIO);

  n = 0;
  for(i = 0; i < 5; i++)
    n = (n * 96 + ((buf[i] & 0x7f) - 32)) & 0xffffffff;

  accesskey = n;

  return(0);
}

Uns32
encrpt(Uns32 in)
{
  Uns32	inp, a, b;

  inp = XOR(in, accesskey);

  a = inp >> 5;
  a &= (1 << 13) - 1;

  a = (Uns32) ((sin((double)a / 8192.0 * (PI_3_8 - PI_1_8) + PI_1_8)
			- S_PI_1_8) / (S_PI_3_8 - S_PI_1_8) * 8192.0);

  b = a;

  a = inp & ((1 << 5) - 1);
  a = a * a * a;

  a &= ((1 << 5) - 1);

  b |= a << 13;

  a = (inp >> 18);
  a &= (1 << 9) - 1;

  a = (Uns32) ((log((double)a / 512.0 * 4.0 + 8.0) - LOG_8)
			/ (LOG_12 - LOG_8) * 512.0);

  b |= a << 23;

  a = (inp >> 27);
  a &= (1 << 5) - 1;

  a = (Uns32) ((4.0 - sqrt((double)a / 32.0 * 7.0 + 9.0)) * 32.0);

  b |= a << 18;

  return(b);
}
