;; $Id: dbttlpg.dsl 1.1 1998/02/08 21:41:31 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ............................. Title Page .............................

(mode titlepage-recto-mode

  (element TITLE 
    (make paragraph
      font-family-name: %title-font-family%
      font-weight: 'bold
      font-size: (HSIZE 5)
      line-spacing: (* (HSIZE 5) %line-spacing-factor%)
      space-before: (* (HSIZE 5) %head-before-factor%)
      quadding: 'center
      keep-with-next?: #t
      (process-children-trim)))

  (element SUBTITLE 
    (make paragraph
      font-family-name: %title-font-family%
      font-weight: 'bold
      font-size: (HSIZE 4)
      line-spacing: (* (HSIZE 4) %line-spacing-factor%)
      space-before: (* (HSIZE 4) %head-before-factor%)
      quadding: 'center
      keep-with-next?: #t
      (process-children-trim)))

  (element AUTHORGROUP
    (make sequence (process-children-trim)))

  (element AUTHOR
    (let ((author-name (author-string))
	  (author-affil (if (not (node-list-empty? 
				  (select-elements 
				   (descendants (current-node)) 
				   "AFFILIATION")))
			    (data (node-list-first
				   (select-elements 
				    (descendants (current-node)) 
				    "AFFILIATION")))
			    "")))

      (make sequence      
	(make paragraph
	  font-family-name: %title-font-family%
	  font-weight: 'bold
	  font-size: (HSIZE 3)
	  line-spacing: (* (HSIZE 1) %line-spacing-factor%)
	  space-before: (* (HSIZE 2) %head-before-factor%)
	  quadding: 'center
	  keep-with-next?: #t
	  (literal author-name))
	(make paragraph
	  font-family-name: %title-font-family%
	  font-weight: 'bold
	  font-size: (HSIZE 1)
	  line-spacing: (* (HSIZE 1) %line-spacing-factor%)
	  space-after: (* (HSIZE 2) %head-after-factor% 4)
	  quadding: 'center
	  keep-with-next?: #t
	  (literal author-affil)))))
)

(define ($verso-titles$ title-nl subtitle-nl)
  (make paragraph
    font-family-name: %title-font-family%
    font-weight: 'bold
    quadding: 'start
    keep-with-next?: #t
    (with-mode titlepage-verso-mode-titles
      (make sequence
	(process-node-list title-nl)
	(if (node-list-empty? subtitle-nl)
	    (empty-sosofo)
	    (make sequence
	      (literal ": ");
	      (process-node-list subtitle-nl)))))))

(mode titlepage-verso-mode-titles
  (element TITLE
    (make sequence
      font-family-name: %title-font-family%
      font-weight: 'bold
      (process-children)))

  (element SUBTITLE
    (make sequence
      font-family-name: %title-font-family%
      font-weight: 'bold
      (process-children)))
)

(mode titlepage-verso-mode

  (element TITLE (empty-sosofo))
  (element SUBTITLE (empty-sosofo))

  (element AUTHORGROUP
    (make paragraph
      use: para-style
      space-after: (* %bf-size% %line-spacing-factor%)
      (make sequence
	(literal %gentext-by%)
	(literal " ")
	(process-children-trim))))

  (element AUTHOR
    ;; Print the author name.  Handle the case where there's no AUTHORGROUP
    (let ((in-group (have-ancestor? "AUTHORGROUP" (current-node))))
      (if (not in-group)
	  (make paragraph
	    ;; Hack to get the spacing right below the author name line...
	    use: para-style
	    space-after: (* %bf-size% %line-spacing-factor%)
	    (make sequence
	      (literal %gentext-by%)
	      (literal " ")
	      (literal (author-list-string))))
	  (make sequence 
	    (literal (author-list-string))))))  

(element EDITOR
    ;; Print the editor name.
    (let ((in-group (have-ancestor? "AUTHORGROUP" (current-node))))
      (if (not in-group)
	  (make paragraph
	    ;; Hack to get the spacing right below the author name line...
	    use: para-style
	    space-after: (* %bf-size% %line-spacing-factor%)
	    (make sequence
	      (literal %gentext-edited-by%)
	      (literal " ")
	      (literal (author-string))))
	  (make sequence 
	    (literal (author-string))))))
)

