;; $Id: dbttlpg.dsl 1.3 1998/02/19 17:58:44 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ............................. Title Page .............................

(mode titlepage-mode

  (element SETINFO 
    ;; If a titlepage is desired, produce it
    ;; If a TOC is desired, produce it after the title page
    ;; If a titlepage is not desired, but a TOC is, 
    (let* ((parent-titles (select-elements (children 
					    (parent (current-node))) 
					   "TITLE"))
	   (exp-children  (expand-children (children (current-node))
					   '("BOOKBIBLIO" 
					     "BIBLIOMISC"
					     "BIBLIOSET")))
	   (info-titles   (select-elements exp-children "TITLE"))
	   (titles        (if (node-list-empty? parent-titles)
			      info-titles
			      parent-titles))
	   (subtitles     (select-elements exp-children "SUBTITLE")))
      
      (if %generate-titlepage%
	  (make element gi: "DIV"
		attributes: (list
			     (list "CLASS" (gi)))
		(make sequence
		  (make element gi: "H1"
			(with-mode title-mode
			  (process-node-list titles)))
		  (make element gi: "H2"
			(with-mode subtitle-mode
			  (process-node-list subtitles)))
		  (with-mode titlepage-mode 
		    (process-children))))
	  (make element gi: "H1"
		(with-mode title-mode
		  (process-node-list titles))))))

  (element BOOKINFO 
    ;; If a titlepage is desired, produce it
    ;; If a TOC is desired, produce it after the title page
    ;; If a titlepage is not desired, but a TOC is, 
    (let* ((parent-titles (select-elements (children 
					    (parent (current-node))) 
					   "TITLE"))
	   (exp-children  (expand-children (children (current-node))
					   '("BOOKBIBLIO" 
					     "BIBLIOMISC"
					     "BIBLIOSET")))
	   (info-titles   (select-elements exp-children "TITLE"))
	   (titles        (if (node-list-empty? parent-titles)
			      info-titles
			      parent-titles))
	   (subtitles     (select-elements exp-children "SUBTITLE")))
      
      (if %generate-titlepage%
	  (make element gi: "DIV"
		attributes: (list
			     (list "CLASS" (gi)))
		(make sequence
		  (make element gi: "H1"
			(with-mode title-mode
			  (process-node-list titles)))
		  (make element gi: "H2"
			(with-mode subtitle-mode
			  (process-node-list subtitles)))
		  (with-mode titlepage-mode 
		    (process-children))))
	  (make element gi: "H1"
		(with-mode title-mode
		  (process-node-list titles))))))

  (element TITLE
    (empty-sosofo))

  (element SUBTITLE
    (empty-sosofo))

  (element AUTHORGROUP
    (make element gi: "P"
	  (make sequence
	    (literal %gentext-by%)
	    (literal " ")
	    (process-children-trim))))

  (element AUTHOR
    ;; Print the author name.  Handle the case where there's no AUTHORGROUP
    (let ((in-group (have-ancestor? "AUTHORGROUP" (current-node))))
      (if (not in-group)
	  (make element gi: "P"
		(make sequence
		  (literal %gentext-by%)
		  (literal " ")
		  (literal (author-list-string))))
	  (make sequence 
	    (literal (author-list-string))))))

  (element EDITOR
    ;; Print the editor name.
    (let ((in-group (have-ancestor? "AUTHORGROUP" (current-node))))
      (if (not in-group)
	  (make element gi: "P"
		(make sequence
		  (literal %gentext-edited-by%)
		  (literal " ")
		  (literal (author-string))))
	  (make sequence 
	    (literal (author-string))))))

  (element EDITION
    (make element gi: "P"
	  ($charseq$)))

  (element PUBDATE (empty-sosofo))

  (element ABSTRACT 
    (make element gi: "BLOCKQUOTE"
	  attributes: '(("CLASS" "ABSTRACT"))
	  (process-children)))

  (element LEGALNOTICE 
    (let ((notices (select-elements 
		    (descendants (parent (current-node)))
		    "LEGALNOTICE")))
      (if %generate-legalnotice-link%
	  ;; Divert the contents of legal to another file.  It will be xref'd
	  ;; from the Copyright.
	  (if (first-sibling? (current-node))
	      (make entity
		system-id: %legalnotice-link-file%
		(make document-type
		  name: "HTML"
		  public-id: %html-pubid%)
		(make element gi: "HTML"
		      (make element gi: "HEAD"
			    ($html-header-meta$))
		      (make element gi: "BODY" 
			    attributes: %body-attr%
			    (header-navigation (current-node))
			    ($semiformal-object$)
			    (with-mode legal-notice-link-mode
			      (process-node-list (node-list-rest notices)))
			    (footer-navigation (current-node)))))
	      (empty-sosofo))
	  (make element gi: "DIV"
		attributes: '(("CLASS" "LEGALNOTICE"))
		($semiformal-object$)))))

  (element COPYRIGHT
    (let ((years (select-elements (descendants (current-node)) "YEAR"))
	  (holders (select-elements (descendants (current-node)) "HOLDER")))
      (make element gi: "P"
	    attributes: (list
			 (list "CLASS" (gi)))
	    (if %generate-legalnotice-link%
		(make sequence
		  (make element gi: "A"
			attributes: (list (list "HREF" %legalnotice-link-file%))
			(literal (gentext-element-name (gi (current-node))))
			(literal " ")
			(literal (dingbat "copyright"))
			(literal " ")
			(process-node-list years))
		  (literal (string-append " " %gentext-by% " "))
		  (process-node-list holders))
		(make sequence
		  (literal (gentext-element-name (gi (current-node))))
		  (literal " ")
		  (literal (dingbat "copyright"))
		  (literal " ")
		  (process-node-list years)
		  (literal (string-append " " %gentext-by% " "))
		  (process-node-list holders))))))
)

(mode legal-notice-link-mode
  (element LEGALNOTICE
    ($semiformal-object$)))

(mode dedication-mode
  (element DEDICATION 
    (make sequence
      ($component-title$ "H3" "H4")
      (process-children)))

  (element (DEDICATION TITLE) (empty-sosofo))
)

