;; $Id: dbprocdr.dsl 1.0 1997/12/30 17:48:14 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================= PROCEDURES =============================

(define (PROCSTEP ilvl)
  (if (> ilvl 1) 2.0em 1.8em))

(element PROCEDURE 
  (let ((titles (select-elements (children (current-node)) "TITLE"))
	(preamble (node-list-filter-by-not-gi (children (current-node))
					      '("STEP")))
	(steps (node-list-filter-by-gi (children (current-node))
				       '("STEP"))))
    (make element gi: "DIV"
	  attributes: (list
		       (list "CLASS" (gi)))
	  (if (not (node-list-empty? titles))
	      (make element gi: "P"
		    (make element gi: "B"
			  (with-mode title-mode
			    (process-node-list titles))))
	      (empty-sosofo))
	  (process-node-list preamble)
	  (make element gi: "OL"
		attributes: (list
			     (list "TYPE" ($hierarch-number-format$ 1)))
		(process-node-list steps)))))

(element (PROCEDURE TITLE) (empty-sosofo))

(element SUBSTEPS
  (make element gi: "OL"
	attributes: (list
		     (list "CLASS" "SUBSTEPS")
		     (list "TYPE" ($hierarch-number-format$
				   (+ ($proc-step-depth$ (current-node)) 1))))
	(process-children)))

(element STEP
  (let ((id (attribute-string "ID")))
    (make sequence
      (make element gi: "LI"
	    (if id
		(make element gi: "A"
		      attributes: (list
				   (list "NAME" id))
		      (empty-sosofo))
		(empty-sosofo))
	    (process-children)))))


