
/*
 * Version number
 */

#define VERSION "0.6"

#define MAX_NAMELENGTH 256
#define MAX_NUMLENGTH 10

#define MAX_CHANNELS 8

#define TMP "/tmp"
#define HOME_ENV "HOME"
#ifdef sun
#define AUDIODEV_ENV "AUDIODEV"
#endif

#define CLIPFILE "xwave_clipboard_file.tmp"

#define MAXUSHORT 65536

#define PREVIEWHEIGHT 256

#define CURSOR_DEFAULT 0
#define CURSOR_MARK 1
#define CURSOR_CLOCK 2

#define LOAD 0
#define SAVE 1
#define CREATE 2

#define MONO 1
#define STEREO 2

/* 
 * error messages !
 * these are hard coded, because if this error occurs we are not able
 * to use user defined resources
 * Ok man knnte natrlich den gleichen Text nochmal in Deutsch
 * darunter schreiben, oder auch in allen Sprachen die es gibt ;)
 */ 

#define NORESOURCE "The application defaults are not loaded !\n\
They are saved in the file \"XWave\" that came with this program.\n\
Please copy it to your \"XAPRESDIR\" (usually \"/usr/lib/X11/app-defaults\"),\
then restart X.\n\
Or load the resources with the command \"xrdb -merge XWave\".\n\n\
Leider konnten die Voreinstellungen fr dieses Programm nicht gefunden\n\
werden. Sie befinden sich in der Datei \"XWave\" und sollten in das\n\
Verzeichnis kopiert werden, in dem alle Voreinstellungen der verschiedenen\n\
X-Programme liegen (\"usr/lib/X11/app-defaults\").\n\
Sie knnen die Voreinstellungen auch mit dem Befehl \"xrdb -merge XWave\" \
laden.\n\n"

#define WRONGRESOURCE "The wrong application defaults are loaded !\n\
Look in \"/usr/lib/X11/app-defaults/XWave\", or there you have placed\n\
the file \"XWave\". There must be a line \"*version:\" with a version number.\n\
The version number must be 0.6. If the version is wrong, look there you have\n\
found this program and replace the old \"XWave\" with the actual.\n\n\
Die Versionsnummer der Voreinstellungen und des Programms sind nicht\n\
identisch. Schauen sie in die Datei \"XWave\" im Verzeichnis der\n\
Voreinstellungen (\"/usr/lib/X11/app-defaults\") nach der Zeile\n\
\"*version:\". Die aktuelle Versionsnummer ist 0.6.\n\n"

typedef struct Main_Widgets {
   Widget  form;			/* main form for geom. management */
   Widget  graph;			/* display on this */
   Widget  stat;			/* Status of actual sample */
   Widget  cmenu;			/* canvas_menu */
   char    messages[MAX_NAMELENGTH];    /* error messages */
} Main_Widget;

typedef struct Main_Graphics {
   GC	   playgc;		/* GC for play-line */
   GC	   markgc;
   GC	   gcl;			/* Graphics Context for left */
   GC	   gcr;			/* Graphics Context for right */
   float   step;		/* the step to fit whole wave in the */
                                /* main window */
   ushort  width;               /* width of main window */
   ushort *fbuf;                /* buffer for waves on disk */                 
   Pixmap  pixmap;		/* pixmap for expose */
   Pixmap  lpixmap;             /* pixmap for playline */       
} Main_Graphic;

typedef struct Canvas_Graphics {
   GC	  markgc;
   GC	  gcl;			/* Graphics Context for left */
   GC	  gcr;			/* Graphics Context for right */
   int 	  step;			/* actual step */
   int	  pos;			/* actual pos. in wave */ 
   int	  width;			
   Pixmap pixmap; 		/* pixmap for expose */
} Canvas_Graphic;

typedef struct Main_Bools {
   bool canplay;		/* is there a play-device ? */
   bool	canplay16bit;		/* and can we play/rec in 16 bit ? */
   bool	canplay44khz;		/* can we play/rec 44 khz ? */
   bool	canplaystereo;		/* can we play in stereo ? */
   bool	canplay44khzstereo;	/* can we play 44khz in stereo ? */
   bool	playing;		/* are we currently playing ? */
   bool	exposing;		/* are we drawing some points ? */
   bool isclip;                 /* something in clipboard ? */
} Main_Bool;

typedef struct Canvas_Bools {
   bool	modified;               /* file is modified */
   bool update;                 /* do real update of display */
   bool canwrite;		/* can we write this file ? */
   bool	exposing;
} Canvas_Bool;
 
typedef struct Canvas_Widgets {
   Widget popup;
   Widget graph;
   Widget scroll;
   Widget zscroll;  
   Widget mentry;
} Canvas_Widget;

typedef struct Next_Waves {
   Wave_Data         *wd;
   Canvas_Widget     *cw;
   Canvas_Bool       *cb;
   Canvas_Graphic    *cg;
   struct Next_Waves *nw;		/* next entry */
} Next_Wave;

typedef struct Clip_Datas {
   Wave_Data *wd;
} Clip_Data;


typedef struct Main_Datas {
   Main_Bool	  *mb;
   Main_Graphic	  *mg;
   Main_Widget	  *mw;
   Wave_Data	  *wd;
   Canvas_Widget  *cw;
   Canvas_Bool    *cb;
   Canvas_Graphic *cg;
   Clip_Data      *cd;
   int		   no;
   int	           maxmem;
   Next_Wave	  *nw;
   char		  *home;
} Main_Data;

typedef struct Sample_Returns {
   byte	res;			/* 8 or 16 bit */
   byte	channels;		/* mono (1) or stereo (2) */
   int 	freq;			/* frequence */
} Sample_Return;

void new_canvas(Widget w,Next_Wave *nw);
void set_actual_canvas(Next_Wave *nw);
void set_cursor(Widget w,byte which);
void watch_cursor(bool state);

