/* $Id: fetch.c,v 1.37 1997/07/20 00:33:38 agulbra Exp $ 

Written by Arnt Gulbrandsen <agulbra@troll.no> and copyright 1995
Troll Tech AS, Postboks 6133 Etterstad, 0602 Oslo, Norway, fax +47
22646949.

Use, modification and distribution is allowed without limitation,
warranty, or liability of any kind.  */

#include <sys/types.h>
#ifdef BSD
#include <sys/errno.h>
#endif
#include <ctype.h>
#include <dirent.h>
#include <fcntl.h>
#include <netdb.h>
#include <netinet/in.h>
#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <syslog.h>
#include <time.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

#include "leafnode.h"

int artno;

time_t now;

struct newsgroup *cg;

int reals, fakes;

int extraarticles = 0;

void store( const char * filename,
	    FILE * filehandle,
	    const size_t bytes,
	    char * newsgroups,
	    const char * subject,
	    const char * from,
	    const char * date,
	    const char * msgid,
	    const char * references,
	    const char * lines);

int age( const char * date );
int getgroup ( struct newsgroup *, int );
int postarticles( void );
void fixxover( void );
void ihave( void );

void  store( const char * filename,
	     FILE * filehandle,
	     size_t bytes,
	     char * newsgroups,
	     const char * subject,
	     const char * from,
	     const char * date,
	     const char * msgid,
	     const char * references,
	     const char * lines)
{
    char tmp[10];
    char xrefincase[4096]; /* 1024 for newsgroups, plus article numbers */
    char * p;
    char * q;
    char * x;
    int n;

    x = xrefincase;
    n = 0;

    if ( verbose == 3 )
	printf( "storing %s\n", msgid );
    else if ( verbose > 3 )
	printf( "storing %s: %s\n", msgid, newsgroups );

    p = newsgroups;
    while (p && *p) {
	n++;
	q = strchr( p, ',' );
	if (q)
	    *q++ = '\0';
	if ( *p ) {
	    if (!cg || strcmp(cg->name, p)) {
		cg = findgroup( p );
		if (cg)
		    chdirgroup( p );
	    }
	    if ( cg ) {
		do {
		    sprintf(tmp, "%d", ++cg->last);
		    errno = 0;
		    if ( verbose > 2 )
			printf( "..as article %d in %s\n",
			       cg->last, cg->name );
		} while ( link( filename, tmp )<0 && errno==EEXIST );
		if ( errno )
		    syslog( LOG_ERR, "error linking %s into %s: %m",
			    filename, p );
		else {
		    sprintf( x, " %s:%d", cg->name, cg->last );
		    x += strlen( x );
		}
	    } else {
		if ( verbose )
		    printf( ".. discarding unknown group %s\n", p );
	    }
	}
	p = q;
    }
    if ( n > 1 )
	fprintf( filehandle, "Xref: %s%s\n", fqdn, xrefincase );
}



int age( const char * date ) {
    char monthname[4];
    int month;
    int year;
    int day;
    const char * d;
    time_t tmp;
    struct tm gmt;

    if ( !date )
	return 1000; /* large number: OLD */
    d = date;
    d += 5; /* "Date:" */
    while( isspace( *d ) )
	d++;

    if ( isalpha( d[0] ) && isalpha( d[0] ) && isalpha( d[2] ) && 
	 d[3] == ',' && isspace( d[4] ) )
	d += 5; /* skip Mon, */

    monthname[0] = '\0';

    if ( sscanf( d, "%d %s %d", &day, monthname, &year ) < 3 )
	return 1003;
    else if ( ! ((year > 95 && year < 100) || (year > 1995)) )
	return 1004;
    else if ( strlen( monthname ) != 3 )
	return 1005;
    else if ( !(day > 0 && day < 32) )
	return 1006;
    else {
	if ( !strcasecmp( monthname, "jan" ) )
	    month = 0;
	else if ( !strcasecmp( monthname, "feb" ) )
	    month = 1;
	else if ( !strcasecmp( monthname, "mar" ) )
	    month = 2;
	else if ( !strcasecmp( monthname, "apr" ) )
	    month = 3;
	else if ( !strcasecmp( monthname, "may" ) )
	    month = 4;
	else if ( !strcasecmp( monthname, "jun" ) )
	    month = 5;
	else if ( !strcasecmp( monthname, "jul" ) )
	    month = 6;
	else if ( !strcasecmp( monthname, "aug" ) )
	    month = 7;
	else if ( !strcasecmp( monthname, "sep" ) )
	    month = 8;
	else if ( !strcasecmp( monthname, "oct" ) )
	    month = 9;
	else if ( !strcasecmp( monthname, "nov" ) )
	    month = 10;
	else if ( !strcasecmp( monthname, "dec" ) )
	    month = 11;
	else {
	    return 1001;
	}
	if ( year > 100 )
	    year -= 1900; /* *sigh */
	tmp = time(0);
	gmt   = *(gmtime(&tmp));
	return ((gmt.tm_year - year)*365 +
		(gmt.tm_mon - month)*28 +
		(gmt.tm_mday - day));
    }
}		       



int getgroup ( struct newsgroup * g, int server ) {
    static char *hd[10];
    char *hnames[10] = {"Path: ", "Message-ID: ", "From: ", "Newsgroups: ",
			"Subject: ", "Date: ", "References: ", "Lines: ", 
			"Xref: ", ""};
    int h;
    int n;
    int last;
    int window; /* last ARTICLE n command sent */
    char *l;
    FILE *f;
    const char *c;
    struct stat st;
    int outstanding;
    static char * stufftoget;

    if ( !g )
	return server;

    if (g->first > g->last)
	g->last = g->first;

    reals = fakes = 0;
    chdirgroup( g->name );

    sprintf( lineout, "GROUP %s\r\n", g->name );
    putaline();

    l = getaline( nntpin );
    if ( !l )
	return server;

    if (sscanf(l, "%3d %d %d %d ", &n, &h, &window, &last) < 4
	|| n != 211 )
	return server;

    if ( extraarticles ) {
	int i;
	i = server - extraarticles;
	if ( i < window )
	    i = window;
	if ( verbose > 1 )
	    printf( "backing up from %d to %d\n",
		    server, i );
	server = i;
    }

    if ( server > last+1 ) {
	syslog( LOG_INFO, "last seen article was %d, server now has %d-%d",
		server, window, last );
	if ( server > last+5 ) {
	    if ( verbose )
		printf( "switched upstream servers? %d > %d\n",
			server-1, last );
	    server = window; /* insane - recover thoroughly */
	} else {
	    if ( verbose )
		printf( "rampant spam cancel? %d > %d\n",
			server-1, last );
	    server = last - 5; /* a little bit too much */
	}
    }
    if ( artlimit && last-server > artlimit ) {
	if ( verbose )
	    printf( "skipping articles %d-%d inclusive (article limit)\n", 
		    server, last-artlimit-1 );
	server = last-artlimit;
    }

    if ( initiallimit && (g->first >= g->last) && 
	 last-server > initiallimit ) {
	if ( verbose )
	    printf( "skipping articles %d-%d inclusive (initial limit)\n", 
		    server, last-initiallimit-1 );
	server = last-initiallimit;
    }

    sprintf( s, "%s/interesting.groups/%s", spooldir, g->name );
    if ( stat( s, &st ) )
	return last; /* race condition: I hope this is proper */

    if ( ((st.st_mtime==st.st_ctime) && (now-st.st_ctime > TIMEOUT_SHORT) &&
	  (server <= last) )
	  || (now-st.st_mtime > TIMEOUT_LONG) ) {
	if ( verbose )
	    printf("skipping %s from now on\n", g->name);
	syslog( LOG_INFO, "skip %s: %d, %d", g->name, server, last );
	unlink( s );
   }

    if ( window < server )
	window = server;
    if ( window < 1 )
	window = 1;
    server = window;

    if ( server <= last ) {
	if ( verbose )
	    printf( "%s: considering articles %d-%d\n", 
		    g->name, server, last );
	sprintf( lineout, "XHDR Message-ID %d-%d\r\n",
		 server, last );
        putaline();
	if ( nntpreply() == 221 ) {
	    stufftoget = (char*) realloc( stufftoget, last + 1 - server );
	    if ( stufftoget )
		memset( stufftoget, 0, last + 1 - server );
	    while ( (l = getaline( nntpin )) && strcmp( l, "." ) ) {
		int art;
		char * t;
		art = strtol(l, &t, 10);
		if (t && isspace( *t )) {
		    while ( isspace( *t ) )
			t++;
		    if ( stufftoget &&
			 art >= server &&
			 art <= last &&
			 stat( lookup( t ), &st ) != 0 )
			stufftoget[ art - server ] = 'y'; /* anything */
		    if ( verbose > 1 && stufftoget[ art - server ] )
			printf( "%s: will fetch %d (%s)\n", g->name, art, t );
		}
	    }
	    if ( !l )
		return server;
	} else {
	    stufftoget = realloc( stufftoget, 0 );
	}
    } else if ( verbose ) {
	printf( "%s: no new articles\n", g->name );
    }

    outstanding = 0;
    while ( window <= last || outstanding ) {
	while ( outstanding < 47 && window <= last ) {
	    while ( stufftoget &&
		    window <= last &&
		    !stufftoget[ window - server ] ) {
		if ( verbose > 3 )
		    printf( "%s: skipping %d - not available or too old\n",
			    g->name, window );
		window++;
	    }
	    if ( window <= last ) {
		outstanding++;
		if ( verbose > 1 ) 
		    printf( "%s: ARTICLE %d (%d up in the air)\n",
			    g->name, window, outstanding );
		sprintf(lineout, "ARTICLE %d\r\n", window++);
		putaline();
	    }
	}

	if ( outstanding > 0 ) {
	    l = getaline( nntpin );
	    if ( !l )
		return server;

	    outstanding--;
	    if (sscanf(l, "%3d %d", &n, &h) < 2 || n != 220 ) {
		if ( verbose )
		    printf( "%s: reply %03d (%d more up in the air)\n",
			    g->name, n, outstanding );
		continue;
	    }

	    if ( verbose )
		printf( "%s: receiving article %d (%d more up in the air)\n",
			g->name, h, outstanding );

	    for ( h=0; h<10; h++ ) {
		if (hd[h])
		    free(hd[h]);
		hd[h] = strdup("");
	    }
	    h = 9;
	    c = NULL;

	    while ( ((l=getaline(nntpin)) != NULL) && strcmp(l, ".") ) {
		if ( !*l ) { /* end of headers */
		    for ( h=0; hd[h] && *(hd[h]) && h<4; h++ )
			;
		    f = NULL;
		    if ( h != 4 ) {
			if ( verbose )
			    printf( "discarding it - no message-id found\n" );
		    } else if ( age( hd[5] ) > 10 ) {
			if ( verbose )
			    printf( "%s posted more than %d days ago: %s",
				    hd[1], 10, hd[5] );
		    } else {
			c = lookup(strchr( hd[1], '<'));
			if ( stat( c, &st ) && errno == ENOENT )
			    f = fopen( c, "w" );
			else if ( verbose )
			    printf( "discarding it - already have it or "
				    "file system error\n" );
		    }
		    if (f) {
			for ( h=0; h<10; h++ )
			    if ( h!=8 && hd[h] && *(hd[h]))
				fprintf( f, "%s", hd[h] );
			h = 0;
			while ( h<8 ) {
			    char * p1;
			    char * p2;
			    p1 = p2 = hd[h];
			    while (p1 && *p1) {
				if ( isspace(*p1) ) {
				    *p2 = ' ';
				    do {
					p1++;
				    } while ( isspace(*p1) );
				} else {
				    *p2 = *p1++;
				}
				if (*p1)
				    p2++;
				else
				    *p2 = '\0';
			    }
			    h++;
			}
			store( c, f, st.st_size,
			       *hd[3] ? hd[3]+strlen(hnames[3]) : "", 
			       *hd[4] ? hd[4]+strlen(hnames[4]) : "", 
			       *hd[2] ? hd[2]+strlen(hnames[2]) : "", 
			       *hd[5] ? hd[5]+strlen(hnames[5]) : "", 
			       *hd[1] ? hd[1]+strlen(hnames[1]) : "", 
			       *hd[6] ? hd[6]+strlen(hnames[6]) : "", 
			       *hd[7] ? hd[7]+strlen(hnames[7]) : "");
		    }
		    do {
			if ( l && *l == '.' )
			    l++;
			if (f)
			    fprintf(f, "%s\n", l);
		    } while ( ((l=getaline(nntpin)) != NULL) &&
			      strcmp(l, ".") );
		    if ( f )
			fclose( f );
		    if ( !l ) {
			unlink( c );
		    } else {
			if ( hd[7] && 
			     ((c=strstr(hd[7], "\nSupersedes:" )) != NULL) ) {
			    /* that isn't strictly correct, it's case sensitive
			       and lacks trailing space */
			    c += strlen( "\nSupersedes:" );
			    while ( c && isspace( *c ) )
				c++;
#ifdef NOTYET
			    if ( *c == '<' && ( (c=lookup( c )) != NULL ))
				/* supersede( c ) */ ;
#endif
			}
		    }
		    break;
		} else { /* still within headers */
		    if ( isspace( *l ) ) {
			hd[h] = critrealloc( hd[h], 
					     strlen(hd[h])+strlen(l)+2,
					     "Fetching article header" );
			strcat( hd[h], l );
			strcat( hd[h], "\n" );
		    } else {
			n = 0;
			while ( strncasecmp( l, hnames[n],
					     strlen(hnames[n]) ) )
			    n++;
			if ( n<9 && hd[n] && *(hd[n]) )
			    /* second occurance is "other header" */
			    n = 9;
			hd[n] = critrealloc( hd[n],
					     strlen(hd[n])+strlen(l)+2,
					     "Fetching article header" );
			strcat( hd[n], l );
			strcat( hd[n], "\n" );
			h = n;
			if ( verbose > 4 && hnames[n] && *hnames[n] )
			    printf( "...saw header %s\n", hnames[n] );
		    }
		}
	    }
	}
    }

    return last +1;
}

/*
 * get active file from remote server
 */
static void nntpactive( void ) {
    char * l;
    int first;
    struct stat st;

    sprintf( s, "%s/active.read", spooldir );
    if ( active && stat( s, &st )==0 && now-st.st_mtime < TIMEOUT_LONG ) {
	if ( verbose )
	    printf( "LIST ACTIVE done only %d seconds ago, skipping\n",
		    (int)(now-st.st_mtime) );
	return;
    }

    if ( verbose )
	printf( "Reading list of active newsgroups\n" );

    sprintf(lineout, "LIST ACTIVE\r\n");
    putaline();

    if ( nntpreply() != 215 )
	return;

    while ( (l=getaline(nntpin)) && ( *l != '.' ) ) {
	char * p;

	p = l;
	while (!isspace(*p) )
	    p++;
	if (*p)
	    *p++ = '\0';
	first = strtol( p, &p, 10); /* to be discarded */
	if ( p && !findgroup( l )) {
	    first = strtol( p, NULL, 10 );
	    insertgroup( l, first, first-1, "", first );
	    syslog( LOG_INFO, "Registered group %s", l );
	}
    }

    if ( verbose )
	printf( "Reading newsgroup descriptions\n" );

    /*
     * add descriptions
     */
    fprintf(nntpout, "LIST NEWSGROUPS\r\n");
    fflush(nntpout);
    if ( nntpreply() == 215 ) {
	while ( (l=getaline(nntpin)) && ( *l != '.' ) ) {
	    char * p;
	    struct newsgroup * g;

	    p = l;
	    while ( !isspace( *p ) )
		p++;
	    if (*p)
		*p++ = '\0';
	    while( isspace( *p ) )
		p++;
	    if ( (g = findgroup(l)) != NULL &&
		 strcmp(p, "?" ) && strcmp(p, "-x-") ) {
		if ( verbose )
		    printf( "new description of %s: %s\n", g->name, p );
		g->desc = strdup(p);
	    } else if ( verbose ) {
		printf( "didn't work out: %s: %s\n", l, p );
	    }
	}
    }

    sprintf( s, "%s/active.read", spooldir );
    unlink( s );
    close( open( s, O_WRONLY|O_CREAT, 0664 ) );
}


/*
 * post all spooled articles
 *
 * if all postings succeed, returns 1
 * if there are no postings to post, returns 1
 * if a posting is strange for some reason, closes the nntp connection
 *  and returns 0.  this is to recover from unknown states
 *
 * a posting is deleted once it has been posted, whether it succeeded
 * or not: we don't want to re-do an error.
 *
 */

int postarticles( void ) {
    char * line;
    DIR * d;
    struct dirent * de;
    FILE * f;
    struct stat st;
    int r;

    if ( chdir( spooldir ) || chdir ( "out.going" ) ) {
	syslog( LOG_ERR, "Unable to cd to outgoing directory: %m" );
	return 1;
    }

    d = opendir( "." );
    if ( !d ) {
	syslog( LOG_ERR, "Unable to opendir out.going: %m" );
	return 1;
    }

    while ( (de=readdir( d )) != NULL ) {
	if ( !stat(de->d_name, &st) &&
	     S_ISREG( st.st_mode ) &&
	     (f=fopen( de->d_name, "r" )) != NULL ) {
	    if ( verbose )
		printf( "Posting %s...\n", de->d_name );
	    sprintf( lineout, "POST\r\n" );
	    putaline();
	    r = nntpreply();
	    if ( r == 340 ) {
		do {
		    line = getaline( f );
		    if ( line ) {
			sprintf( lineout, "%s\r\n", line );
			putaline();
		    }
		} while ( line && strcmp( line, "." ) );
		if ( !line ) {
		    if ( verbose )
			printf( " - failed: %03d reply to POST\n", r );
		    sprintf( s, "%s/failed.postings", spooldir );
		    mkdir( s, 0775 );
		    sprintf( s, "%s/failed.postings/%s", 
			     spooldir, de->d_name );
		    syslog( LOG_ERR, 
			    "unable to post (%s), moving to %s",
			    line, s );
		    if ( rename( de->d_name, s ) )
			syslog( LOG_ERR,
				"unable to move failed posting to %s: %m",
				s );
		    closedir( d );
		    fclose( nntpout );
		    return 0; /* strange state, so re-connect */
		}
		line = getaline( nntpin );
		if ( line && !strncmp( line, "240", 3 ) ) {
		    if ( verbose )
			printf( " - OK\n" );
		    syslog( LOG_INFO, "posted article" ); /* useless */
		    unlink( de->d_name);
		} else {
		    if ( line && !strncmp( line, "441 435", 7 ) ) {
			if ( verbose )
			    printf(" - upstream server had that message-id\n");
			unlink( de->d_name );
		    } else {
			if ( verbose )
			    printf( " - article rejected: %s\n", line );
			sprintf( s, "%s/failed.postings", spooldir );
			mkdir( s, 0775 );
			sprintf( s, "%s/failed.postings/%s", 
				 spooldir, de->d_name );
			syslog( LOG_ERR, 
				"unable to post (%s), moving to %s",
				line, s );
			if ( rename( de->d_name, s ) )
			    syslog( LOG_ERR,
				    "unable to move failed posting to %s: %m",
				    s );
			closedir( d );
			fclose( nntpout );
			return 0;
		    }
		}
	    } else
		syslog( LOG_ERR, "unable to post: %03d", r );
	    fclose( f );
	}
    }
    closedir( d );
    return 1;
}



/*
 * try to IHAVE all spooled articles
 *
 * a posting is _not_ deleted once it has been posted
 *
 */

void ihave( void ) {
    char * line;
    DIR * d;
    struct dirent * de;
    FILE * f;
    struct stat st;

    if ( chdir( spooldir ) || chdir ( "out.going" ) ) {
	syslog( LOG_ERR, "Unable to cd to outgoing directory: %m" );
	return;
    }

    d = opendir( "." );
    if ( !d ) {
	syslog( LOG_ERR, "Unable to opendir out.going: %m" );
	return;
    }

    while ( (de=readdir( d )) != NULL ) {
	if ( !stat(de->d_name, &st) &&
	     S_ISREG( st.st_mode ) &&
	     (f=fopen( de->d_name, "r" )) != NULL ) {
	    do {
		line = getaline( f );
		if ( line && !*line ) {
		    syslog( LOG_ERR, "No message-id in %s", de->d_name );
		    sprintf( s, "%s/failed.postings", spooldir );
		    (void) mkdir( s, 0775 );
		    sprintf( s, "%s/failed.postings/%s", 
			     spooldir, de->d_name );
		    if ( rename( de->d_name, s ) )
			syslog( LOG_ERR,
				"unable to move failed posting to %s: %m", s );
		    break;
		}
	    } while ( line && strncasecmp( line, "Message-ID: ", 12 ) );
	    if ( line && strlen( line+12 ) ) {
		char * msgid;
		msgid = line+12;
		while( msgid && *msgid && isspace(*msgid) )
		    msgid++;
		msgid = strdup( msgid );
		sprintf( lineout, "IHAVE %s\r\n", msgid );
		putaline();
		if ( nntpreply() == 335 ) {
		    fseek( f, 0, SEEK_SET );
		    do {
			line = getaline( f );
			if ( line )
			    sprintf( lineout, "%s\r\n", line );
                            putaline();
		    } while ( line && strcmp( line, "." ) );
		    syslog( LOG_INFO, "IHAVE %s received %03d reply",
			    msgid, nntpreply() );
		}
	    }
	}
    }
    closedir( d );
}




static void processactive( void ) {
    DIR * d;
    struct dirent * de;
    struct newsgroup * g;

    sprintf( s, "%s/interesting.groups", 
	     spooldir );
    d = opendir( s );
    if ( !d ) {
	syslog( LOG_ERR, "opendir %s: %m", s );
	return;
    }

    while ( (de=readdir(d)) ) {
	if ( isalpha( *(de->d_name) ) ) {
	    g = findgroup( de->d_name );
	    if ( g ) {
		g->alive = 1;
		g->server = getgroup( g, g->server );
		syslog( LOG_INFO, "%s: fetched to %d", g->name, g->server );
	    }
	}
    }
    rewinddir( d );
    while ( (de=readdir(d)) ) {    
	if ( de->d_name[0] == '.' && isalpha( de->d_name[1] ) ) {
	    g = findgroup( de->d_name + 1 );
	    if ( verbose > 3 && (!g || !g->alive) )
		printf( "considering %s - %s upstream\n", de->d_name+1,
			g ? " exists" : "does not exist" );
	    if ( g && !g->alive ) {
		g->alive = 1;
		g->last++;
	    }
	}
    }
    closedir( d );
}



static void processsupplement( const char * supplement ) {
    FILE * f;
    DIR * d;
    char * l;
    struct dirent * de;
    struct newsgroup * g;
    struct stat st;
    int fd;
    int server = 0, havefile = 0;

    static char * stuff ;

    /* read supplementary server info */
    sprintf( s, "%s/%s", libdir, supplement );
    fd = open( s, O_RDONLY );
    if ( stat( s, &st ) == 0 ) {
        if ( verbose > 3 )
            printf( "Read supplementary server info from %s\n", s );
        stuff = critmalloc( st.st_size+1, "Reading supplementary server info" );
        if ( (fd=open( s, O_RDONLY))<0 ||
             (read( fd, stuff, st.st_size ) < st.st_size) ) {
            syslog( LOG_ERR, "can't open/read %s: %m", s );
	    havefile = 0;
            free( stuff );
        } else {
	    havefile = 1;
            close( fd );
            stuff[st.st_size] = '\0'; /* 0-terminate string */
	}
    }

    sprintf( s, "%s/interesting.groups", 
	     spooldir );
    d = opendir( s );
    if ( !d ) {
	syslog( LOG_ERR, "opendir %s: %m", s );
	return;
    }

    sprintf( s, "%s/%s", libdir, supplement );
    f = fopen( s, "w" );
    if ( ( f == NULL ) && verbose )
        printf( "Couldn't open %s for writing.\n", s );
    while ( (de=readdir(d)) ) {
	if ( isalpha( *(de->d_name) ) ) {
	    g = findgroup( de->d_name );
	    if ( g ) {
	        g->alive = 1;
		if ( havefile == 1 ) {
		/* TODO: this doesn't work properly */
		    l = strstr( stuff, g->name );
		    if ( l == NULL )
		        server = 0;
		    else {
		        l = strchr( l, ' ' );
		        server = strtol( l, NULL, 10 );
		    }
		}
		else
		    server = 0;
#ifdef BROKEN
		server = getbymsgid(g, server);
#endif
		if ( f != NULL )
                    fprintf( f, "%s %d\n", de->d_name, server );
            }
	}
    }
    closedir( d );
    if ( f != NULL )
        fclose(f);

    free( stuff );
}



void fixxover( void ) {
    DIR * d;
    struct dirent * de;

    sprintf( s, "%s/interesting.groups", 
	     spooldir );
    d = opendir( s );
    if ( !d ) {
	syslog( LOG_ERR, "opendir %s: %m", s );
	return;
    }

    while ( (de=readdir(d)) ) {
	if ( isalpha( *(de->d_name) ) && findgroup( de->d_name ) ) {
	    chdirgroup( de->d_name );
	    getxover();
	}
    }
    closedir( d );
}



int main( int argc, char ** argv ) {
    struct passwd * pw;
    int option;
    FILE *lf;
    int usesupplement;

    verbose = 0;
    usesupplement = 0;

    pw = getpwnam( "news" );
    if ( !pw ) {
	fprintf( stderr, "no such user: news\n" );
	exit( 1 );
    }

    setregid( pw->pw_gid, pw->pw_gid );
    setreuid( pw->pw_uid, pw->pw_uid );

    if ( getuid() != pw->pw_uid || getgid() != pw->pw_gid ) {
	fprintf( stderr, "%s: must be run as news or root\n", argv[0] );
	exit( 1 );
    }

    if ( (lf = fopen(lockfile, "r+")) != NULL ) {
        fprintf( stderr, "lockfile %s exists, abort fetch ...\n", lockfile);
        exit( 1 );
    }

    while ( (option=getopt( argc, argv, "lvx:" )) != -1 ) {
	if ( option == 'v' ) {
	    verbose++;
	} else if ( option == 'x' ) {
	    char *nptr, *endptr;
	    nptr = optarg;
	    endptr = NULL;
	    extraarticles = strtol( nptr, &endptr, 0 );
	    if ( !nptr || !*nptr || !endptr || *endptr || !extraarticles ) {
		fprintf( stderr, "Usage: fetch [-v] [-x #] [-l]\n"
			 "  -v: more verbose (may be repeated)\n"
			 "  -x: check for # extra articles in each group\n"
			 "  -l: don't use supplementary servers\n" );
                unlink( lockfile );
		exit( 1 );
	    }
	} else if ( option == 'l' ) {
	    usesupplement = 0;
	}
    }

    if ( verbose ) {
	printf( "%s: verbosity level is %d\n", version, verbose );
	if ( verbose > 3 ) {
	    printf("Don't fetch threads that nobody has read after %d days\n",
	           TIMEOUT_LONG/3600/24);
	    printf("Don't fetch threads that have been read once after %d days\n",
	           TIMEOUT_SHORT/3600/24);
        }
    }

    whoami();

    now = time(NULL);

    umask(2);

    openlog( "fetch", LOG_PID|LOG_CONS, LOG_NEWS );

    readconfig();
    if ( upstream == NULL ) {
	if ( verbose )
	    printf( "can't find an upstream server\n" );
	syslog( LOG_ERR, 
		"no server name in %s", s );
        unlink( lockfile );
	exit( 2 );
    }

    if (!nntpconnect()) {
        syslog( LOG_ERR, "unable to connect to %s", upstream );
        fprintf( stderr, "unable to connect to %s\n", upstream );
    } else {
        do {
	    ihave();
	    sprintf( lineout, "MODE READER\r\n" );
	    putaline();
	    fflush( nntpout );
	    if ( nntpreply() == 498 )
	        continue;
        } while ( !postarticles() );
	if (verbose)
	    printf("Connecting to %s ...\n", upstream);
	readactive();	/* read groupinfo file */
	nntpactive();	/* get information from remote server */
	processactive();

	sprintf( lineout, "QUIT\r\n"); /* say it, then just exit :) */
	putaline();
	writeactive();	/* write groupinfo file */
    }

    while ( usesupplement && supplement ) {
	if ( nntpout )
	    fclose( nntpout );
	if ( nntpin )
	    fclose( nntpin );
	nntpin = nntpout = NULL;
	upstream = supplement->name;
	if ( verbose )
	    printf("Trying to connect to %s ... ", supplement->name);
	if ( nntpconnect() ) {
	    if (verbose)
	        printf("connected.\n");
	    ihave();
	    sprintf( lineout, "MODE READER\r\n" );
	    fflush( nntpout );
	    if ( nntpreply() != 498 ) {
		(void) postarticles();
		processsupplement( supplement->name );
	    }
	    sprintf( lineout, "QUIT\r\n"); /* say it, then just exit :) */
	    putaline();
	    writeactive();
	}
	else {
	    if ( verbose )
	        printf("failed.\n");
	}
	supplement = supplement->next;
    }
	
    syslog( LOG_INFO, "done" );

    if ( verbose || (fork() <= 0) ) {
#if defined(PRIO_MAX)
        setpriority( PRIO_PROCESS, 0, PRIO_MAX/2 );
#endif
        fixxover();
    }

    unlink( lockfile );
    exit(0);
}
