/*
 * tnmUnixLog.c --
 *
 *	UNIX specific functions to write to the syslog facility.
 *
 * Copyright (c) 1993-1996 Technical University of Braunschweig.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "tnmInt.h"
#include "tnmPort.h"

#include <syslog.h>


/*
 *----------------------------------------------------------------------
 *
 * TnmWriteLogMessage --
 *
 *	This procedure is invoked to write a message to the UNIX 
 *	syslog facility.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	A message is written to the syslog facility.
 *
 *----------------------------------------------------------------------
 */

int
TnmWriteLogMessage(interp, level, message)
    Tcl_Interp *interp;
    int level;
    char *message;
{
    switch (level) {
      case TNM_LOG_EMERG:
	level = LOG_EMERG; 
	break;
      case TNM_LOG_ALERT:
	level = LOG_ALERT;
	break;
      case TNM_LOG_CRIT:
	level = LOG_CRIT;
	break;
      case TNM_LOG_ERR:
	level = LOG_ERR;
	break;
      case TNM_LOG_WARNING:
	level = LOG_WARNING;
	break;
      case TNM_LOG_NOTICE:
	level = LOG_NOTICE;
	break;
      case TNM_LOG_INFO:
	level = LOG_INFO;
	break;
      case TNM_LOG_DEBUG:
	level = LOG_DEBUG;
	break;
      default:
	if (interp) {
	    Tcl_SetResult(interp, "illegal system logging level", TCL_STATIC);
	}
	return TCL_ERROR;
    }

    if (message != NULL) {

#ifdef ultrix
	openlog("scotty", LOG_PID);
#else
	openlog("scotty", LOG_PID, LOG_USER);
#endif
	syslog(level, "%s", message);
	closelog();
    }

    return TCL_OK;
}
