/*
 * tnmAsn1.h --
 *
 *	Definitions for the ASN.1/BER encoder/decoder for the SNMP
 *	protocol. This is only the subset of ASN.1/BER required by
 *	the SNMP protocol.
 *
 * Copyright (c) 1994-1996 Technical University of Braunschweig.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _TNMASN1
#define _TNMASN1

/*
 *----------------------------------------------------------------
 * Definition of ASN.1 data types used by SNMP.
 *----------------------------------------------------------------
 */

#define ASN1_UNIVERSAL		( 0x00 )
#define ASN1_APPLICATION	( 0x40 )
#define ASN1_CONTEXT		( 0x80 )
#define ASN1_PRIVATE		( 0xc0 )

#define ASN1_PRIMITIVE		( 0x00 )
#define ASN1_CONSTRUCTED	( 0x20 )

#define	ASN1_OTHER		( ASN1_UNIVERSAL | 0x00 )
#define ASN1_BOOLEAN		( ASN1_UNIVERSAL | 0x01 )
#define	ASN1_INTEGER		( ASN1_UNIVERSAL | 0x02 )
#define ASN1_BIT_STRING		( ASN1_UNIVERSAL | 0x03 )
#define	ASN1_OCTET_STRING	( ASN1_UNIVERSAL | 0x04 )
#define	ASN1_NULL		( ASN1_UNIVERSAL | 0x05 )
#define ASN1_OBJECT_IDENTIFIER	( ASN1_UNIVERSAL | 0x06 )
#define ASN1_SEQUENCE		( ASN1_UNIVERSAL | 0x10 )
#define	ASN1_SEQUENCE_OF	( ASN1_UNIVERSAL | 0x11 )

#define ASN1_IPADDRESS		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x00 )
#define ASN1_COUNTER32		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x01 )
#define ASN1_GAUGE32		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x02 )
#define ASN1_TIMETICKS		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x03 )
#define ASN1_OPAQUE		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x04 )
#define ASN1_NSAPADDRESS	( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x05 )
#define ASN1_COUNTER64		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x06 )

/*
 *----------------------------------------------------------------
 * Exception codes used in SNMPv2 varbind lists (RFC 1905).
 *----------------------------------------------------------------
 */

#define ASN1_NO_SUCH_OBJECT	( ASN1_CONTEXT | ASN1_PRIMITIVE | 0x00 )
#define ASN1_NO_SUCH_INSTANCE	( ASN1_CONTEXT | ASN1_PRIMITIVE | 0x01 )
#define ASN1_END_OF_MIB_VIEW	( ASN1_CONTEXT | ASN1_PRIMITIVE | 0x02 )

/*
 *----------------------------------------------------------------
 * Non-aggregate types for MIB tree nodes that are not defined in
 * SMI or to distinguish from their SNMPv1 values. XXX
 *----------------------------------------------------------------
 */

#define	NetworkAddress		( 0x15 )

EXTERN TnmTable tnmSnmpTypeTable[];

/*
 *----------------------------------------------------------------
 * Object identifier are represented as a vector of unsigned int.
 * The maximum length of an object identifier is 128 (section 4.1
 * of RFC 1905).
 *----------------------------------------------------------------
 */

#define TNM_OIDMAXLEN 128
typedef u_int Tnm_Oid;

/*
 *----------------------------------------------------------------
 * Functions that manipulate object identifier.
 *----------------------------------------------------------------
 */

EXTERN char*
Tnm_OidToStr		_ANSI_ARGS_((Tnm_Oid *oid, int len));

EXTERN Tnm_Oid*
Tnm_StrToOid		_ANSI_ARGS_((char *str, int *len));

EXTERN Tnm_Oid*
Tnm_OidDup		_ANSI_ARGS_((int *buflen, Tnm_Oid *oid, int oidLen));

EXTERN int
Tnm_IsOid		_ANSI_ARGS_((char *str));

EXTERN char*
Tnm_HexToOid		_ANSI_ARGS_((char *str));

/*
 *----------------------------------------------------------------
 * This function return a static error string describing the last 
 * error which incurred in the BER encoder/decoder.
 *----------------------------------------------------------------
 */

EXTERN char*
Tnm_BerError		_ANSI_ARGS_((void));

/*
 *----------------------------------------------------------------
 * BER functions visible for other modules (encoding/decoding):
 *----------------------------------------------------------------
 */

EXTERN u_char*
Tnm_BerEncLength	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char *len_fld, int length));
EXTERN u_char*
Tnm_BerDecLength	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_int *length));
EXTERN u_char*
Tnm_BerEncInt		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     int tag, int value));
EXTERN u_char*
Tnm_BerDecInt		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     int tag, int *value));
EXTERN u_char*
Tnm_BerEncCounter64	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     double value));
EXTERN u_char*
Tnm_BerDecCounter64	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     double *value));
EXTERN u_char*
Tnm_BerEncOID		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     Tnm_Oid *oid, int oidlen));
EXTERN u_char*
Tnm_BerDecOID		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     Tnm_Oid *oid, int *oidlen));
EXTERN u_char*
Tnm_BerEncOctetString	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     int tag, char *octets, int len));
EXTERN u_char*
Tnm_BerDecOctetString	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     int tag, char **octets, int *len));
EXTERN u_char*
Tnm_BerEncNull		_ANSI_ARGS_((u_char *packet, int *packetlen, int tag));

EXTERN u_char*
Tnm_BerDecNull		_ANSI_ARGS_((u_char *packet, int *packetlen, int tag));

#endif /* _TNMASN1 */
