'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH job n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
job \- Invoke Tcl procedures at regular intervals.
.BE

.SH DESCRIPTION
The \fBjob\fR command provides a convenient mechanism to implement Tcl
procedures that are invoked at regular intervals. Jobs are activated
from the Tcl event loop. Every job can have arbitrary attributes to
store job specific state information between two invocations. These
attributes help to avoid global variables in order to keep the Tcl
name-space clean.

.SH JOB COMMAND
The \fBjob\fR command allows to create new jobs and to wait for jobs
to complete. The \fBjob\fR command can also be used to retrieve status
information from the job scheduler.
.TP
.B job create \fR[\fIoption value\fR ...]
The \fBjob create\fR command creates a new job object. The
\fIoptions\fR can be used to configure the behaviour of the new
job. See the configure command below for the details.
.TP
.B job current
The \fBjob current\fR command returns the name of the currently
running job. An empty string is returned if no job is running.
.TP
.B job info
The \fBjob info\fR command returns a list of all job names. The list
will be empty if there are no jobs known in this Tcl interpreter.
.TP
.B job schedule
The \fBjob schedule\fR command invoke the scheduler. This is usually
done automatically from the event loop. This command may be used
during long computations since the scheduler is not preemptive. Note,
this command can cause arbitrary side effects and should be used with
care.
.TP
.B job wait
The \fBjob wait\fR command blocks until all existing jobs have been
finished. The command will wait infinitely if there is at least one
job left. Events are processed while waiting for the jobs to finish
which can have arbitrary side effects.

.SH JOB INSTANCE COMMAND
Every job is represented by a job object command which allows to
manipulate the job.
.TP
.B job# attribute \fR[\fIname \fR[\fIvalue\fR]\fR]
The \fBjob# attribute\fR command allows to save job specific data in
job attributes. If called without any arguments, all existing
attribute names for this job will be returned. If called with a name
argument, the current value of the attribute will be
returned. Non-existing attributes do not produce an error. Instead, an
empty string is returned. Calling the option with a name and a value
causes the value to be saved in the job attribute.
.TP
.B job# cget \fIoption\fR
The \fBjob# cget\fR command returns the current value of a
configuration option. See the description of supported options below.
.TP
.B job# configure \fR[\fIoption value\fR ...]
The \fBjob# configure\fR command manipulates configuration options.
See the description of supported options below. A list describing all
current options is returns if the \fIoptions\fR argument is missing.
.TP
.B job# destroy
The \fBjob# destroy\fR command destroys the job object. This command
forces the object to change into the expired state. The scheduler will
cleanup this object the next time it is active.
.TP
.B job# wait
The \fBjob# wait\fR command blocks and processes events until the
current job changes into the expired state.

.SH JOB OPTIONS
Every job has associated configuration options which control when a
job is activated and which Tcl command is bound to the job.
.TP
.BI "-command " command
The \fB-command\fR option defines the Tcl command that is evaluated 
whenever the job is activated.
.TP
.BI "-interval " time
The \fB-interval\fR option defines the time interval between two job 
activations in milliseconds. 
.TP
.BI "-iterations " number
The \fB-iterations\fR option defines the total number of times that a
job is activated. If this value reaches 0, the job will change its
state to expired. Note, if the iterations options is never used, it
will also have the value 0 but nothing special happens to the job
object.
.TP
.BI "-status " state
The \fB-status\fR option provides access to the current job state. A
job is always in one of the states waiting, suspended, running and
expired. A job in the expired state will be removed from the system
once the scheduler gets activated again. Suspended jobs are not
activated by the job scheduler. A suspended job can be resumed by
changing its state to running.
.TP
.BI "-time " time
The \fB-time\fR option returns the number of milliseconds until this
job is activated the next time. This option is read-only.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
