/*
 *  qftp
 *  Copyright (C) 1997,1998 Peter Strand
 *  Distributed under the GNU Pulic Licence
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>

#include "conf.h"

Conf::Conf()
{
	setdef();
}

Conf::Conf(Conf &cf)
{
	opts = cf.opts;
}

Conf::Conf(Conf &cf, int argc, char *argv[], char *valid)
{
	setdef();
	Parse(cf, argc, argv, valid);
}

Conf::Parse(int fd)
{
	char tmp[4000], *p, *r, *f[50], c;
	int i;
	read(fd, tmp, 4000);
	p = tmp;
	i = 1;
	f[0] = "";
	while (r = strsep(&p, ", \n\r\t")) {
		f[i++] = r;
	}
	optind = 0;
	while (((c = getopt(i, f, "bBcCfFnNaAzZu:UlLrRqQs:S")) != EOF)) {
		set(c);
	}
	
}

Conf::Parse(Conf &cf, int argc, char *argv[], char *valid)
{
	char c, *p;

	opts = cf.opts;
	
	optind = 0;

	while (((c = getopt(argc, argv, valid)) != EOF)) {
		set(c);
	}
}

void Conf::print()
{
	printf("(b) Background:       %d\n", opts.bg);
	printf("(z) Un(g)zip (view):  %d\n", opts.proc);
	printf("(f) Force:            %d\n", opts.force);
	printf("(c) Continue (reget): %d\n", opts.cont);
	printf("(l) Long Listing:     %d\n", opts.longl);
	printf("(a) Anonymous:        %d\n", opts.anon);
	printf("(s) Retry:Sleep   %2d:%2d\n", opts.retry, opts.retrsl);
	printf("(n) Forget host&user: %d\n", opts.noinf);
	printf("(r) Recursive:        %d\n", opts.rec);
	printf("(q) Quiet:            %d\n", opts.quiet);
	printf("(u) User:Pass         %s\n", opts.user);
}

void Conf::setdef()
{
	optarg = "";
	set('B');
	set('z');
	set('F');
	set('C');
	set('L');
	set('A');
	set('S');
	set('N');
	set('R');
	set('Q');
	set('U');
}

void Conf::set(char c)
{
	char *p;
	switch (c) {
	case 'B':
	case 'b': opts.bg = (c & 0x20) >> 5; break;
	case 'Z':
	case 'z': opts.proc = (c & 0x20) >> 5; break;
	case 'F':
	case 'f': opts.force = (c & 0x20) >> 5; break;
	case 'C':
	case 'c': opts.cont = (c & 0x20) >> 5; break;
	case 'L':
	case 'l': opts.longl = (c & 0x20) >> 5; break;
	case 'A':
	case 'a': opts.anon = (c & 0x20) >> 5; break;
	case 'S':
		opts.retry = 0; opts.retrsl = 0; break;
	case 's':
		opts.retry = atoi(optarg);
		if (p = strchr(optarg, ':')) {
			opts.retrsl = atoi(p + 1);
		}
		break;
	case 'N':
	case 'n': opts.noinf = (c & 0x20) >> 5; break;
	case 'R':
	case 'r': opts.rec = (c & 0x20) >> 5; break;
	case 'Q':
	case 'q': opts.quiet = (c & 0x20) >> 5; break;
	case 'U': *opts.user = 0; break;
	case 'u': strcpy(opts.user, optarg); break;
	}
}


struct config *Conf::Get()
{
	return &opts;
}




