/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifndef MAIN
#define MAIN
#include <sys/file.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#if !defined Linux && !defined FreeBSD
#include <errno.h>
#if defined HP_UX
extern char **sys_errlist;
#endif
#endif
#if !defined HAVE_SYS_ERRLIST
#define _PFTP_ERROR_ARRAY_     "Unknown error"
#define _PFTP_ERROR_ARRAY_PID_ "Unknown error"
#else
#define _PFTP_ERROR_ARRAY_     *(sys_errlist+errno)
#define _PFTP_ERROR_ARRAY_PID_ *(sys_errlist+pid)
#endif

#define PFTPRESOURCE         "/.pftprc"
#define MAXCLIENTHOSTS       100 /* see main.c */
#define MAXCLIENTS           5 /* see main.c */
#define VERSION              "0.7.6"
#define LONAME               1024
#define SONAME               256
#define BIT_ONE              01
#define BIT_TWO              02
#define BUFSIZE              32767
#define DEFAULT_STDIN_BUFSIZ 4096

#include "status.h"
extern struct status_type *statstr[MAXCLIENTS+1];

struct client_type {
   char **argv;
   int argc;
};

#ifdef USE_POSIX_THREAD
extern pthread_mutex_t interactiv;
#endif
extern short CHILDNUM; /* number of children currently running */
extern int OUTPUT;
extern int s;         /* Socket */
extern volatile short _WINROWS_; /* Number of rows on the screen */
extern volatile short _WINCOLS_; /* Number of columns on the screen */
extern char *pftplog;  /* holds the name of the log file if any */
extern char *_CLIENTHOSTNAME_[MAXCLIENTHOSTS]; /* specified client host names */
extern char *filter[SONAME]; /* holds the name of the filter program and its arguments */
extern char *_STDOUT_BUFFER_; /* buffers stdout data */

#endif
