/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include "status.h"
#define MAXCLIENTS      5 /* see main.h */
struct status_type  *statstr[MAXCLIENTS+1]; /* status structure vector */
int s=0; /* Socket */
#ifdef USE_POSIX_THREAD
short CHILDNUM; /* number of children currently running */
int OUTPUT=0;
#endif
volatile short _WINROWS_; /* Number of rows on the screen */
volatile short _WINCOLS_; /* Number of columns on the screen */
char *pftplog=NULL;  /* holds the name of the log file if any */
#define MAXCLIENTHOSTS 100 /* see main.h */
char *_CLIENTHOSTNAME_[MAXCLIENTHOSTS]; /* specified client host names */
#define SONAME 256 /* see main.h */
char *filter[SONAME]; /* holds the name of the filter program and its arguments */
char *_STDOUT_BUFFER_; /* buffers stdout data */
#ifdef USE_POSIX_THREAD
pthread_mutex_t interactiv;
void pthread_sync(void *);
#endif

void Server(int);
int argum(int, char **, int *);
void Client(int, int, char **);
void set_tty(int);

int main(int argc, char **argv)
{
   int portn=0, y;

   *filter = (char *)NULL;
   MEM_CHECK((*statstr = (struct status_type *)calloc(1, sizeof(struct status_type))));
   for (y=1; y <= MAXCLIENTS; y++) *(statstr+y) = NULL;
   (*statstr)->pid             = 0;
   (*statstr)->_HOSTNAME_      = NULL;
   (*statstr)->REMOTEHOSTNAME  = NULL;
   (*statstr)->_STDIN_BUFFER_  = NULL;
   _STDOUT_BUFFER_             = NULL;
   (*statstr)->_STDIN_BUFSIZ_  = 0;
   (*statstr)->_SET_STDIN_BUF_ = 0;
   set_tty(3);
#ifdef USE_POSIX_THREAD
   pthread_mutex_init(&interactiv, NULL);
#endif
   for (y=0; y < MAXCLIENTHOSTS; y++) _CLIENTHOSTNAME_[y] = NULL;

   /*
    * Check options.
    */
   y = argum(argc, argv, &portn);

   /*
    * Get Portnumber.
    */
   if (argc > 1) {
      if (!portn || (atoi(argv[1]) > 0 && strlen(argv[1]) < 6)) portn = atoi(argv[1]);
    }
   if (portn < 1025) {
      fprintf(stderr, "** Portnumber has to be bigger then 1024.\n");
      exit(1);
   }

   /*
    * Start server/client.
    */
   if (y) {
#ifdef USE_POSIX_THREAD
      CHILDNUM = 0;
#endif
      if ((*statstr)->_SET_STDIN_BUF_) {
         fflush(stdout);
         setvbuf(stdout, _STDOUT_BUFFER_, \
         _STDOUT_BUFFER_ ?  _IOFBF : _IONBF, \
         (*statstr)->_SET_STDIN_BUF_ ? (*statstr)->_STDIN_BUFSIZ_: BUFSIZ);
      }
      Server(portn);
   }
   else {
#ifdef USE_POSIX_THREAD
      CHILDNUM = -1;
#endif
      Client(portn, argc, argv);   
   }

   exit(0);
}

#ifdef USE_POSIX_THREAD
int init_struct(void)
{
   int strnum=1;

   for (strnum=1; (*(statstr+strnum)) && (!(*(statstr+strnum))->free) \
         && strnum <= MAXCLIENTS; strnum++);
   if (strnum > MAXCLIENTS) return 0; /* Client will be denied */
/*
   while ((*(statstr+strnum)) && (!(*(statstr+strnum))->free) \
         && strnum <= MAXCLIENTS) strnum++;
*/
   if (!*(statstr+strnum)) MEM_CHECK((*(statstr+strnum) = (struct status_type *)calloc(1, sizeof(struct status_type))));
   (*(statstr+strnum))->_STANDARD_INPUT_ = (*statstr)->_STANDARD_INPUT_;
   (*(statstr+strnum))->_RECURS_         = (*statstr)->_RECURS_;
   (*(statstr+strnum))->lol              = (*statstr)->lol;
   (*(statstr+strnum))->OVERWRITE        = (*statstr)->OVERWRITE;
   (*(statstr+strnum))->_SKIP_           = (*statstr)->_SKIP_;
   (*(statstr+strnum))->_OPTIONS_        = (*statstr)->_OPTIONS_;
   (*(statstr+strnum))->usefilter        = (*statstr)->usefilter;
   (*(statstr+strnum))->size             = (*statstr)->size;
   (*(statstr+strnum))->pid              = (*statstr)->pid;
   (*(statstr+strnum))->free             = 0;
   if ((*statstr)->REMOTEHOSTNAME) {
      if ((*(statstr+strnum))->REMOTEHOSTNAME) free((*(statstr+strnum))->REMOTEHOSTNAME);
      MEM_CHECK(((*(statstr+strnum))->REMOTEHOSTNAME = (char *)calloc((*(statstr+strnum))->size, sizeof(char))));
      strcpy((*(statstr+strnum))->REMOTEHOSTNAME, (*statstr)->REMOTEHOSTNAME);
   }
   else (*(statstr+strnum))->REMOTEHOSTNAME = (char *)NULL;
   if (!CHILDNUM) OUTPUT=0;
      
   return strnum;
}
#endif
