/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include "connect.h"
#include "main.h"

extern void shost(int, int *, char *);
extern void lhost(char *, int *);
extern short get_var_from_pftprc(const char *, char *);
int printlist(int, char *, char *);
void getoffset(char *);
long offset[SONAME];  /* hold all offsets of the beginning of files */

void help(char **argv) {
      fprintf(stderr, "\n*** Port-FTP Version %s ", VERSION); 
      fprintf(stderr, "Copyright (C) 1996, 1997, 1998 Ben Schluricke ***\n\n");
      fprintf(stderr, " Usage:\n");
      fprintf(stderr, "  Server: %s [port] [OPTIONS]\n", *argv);
      fprintf(stderr, "             -[b[NUM]] a) remote stdin is written to stdout [buffered]\n");
      fprintf(stderr, "                       b) exit after first connection\n");
      fprintf(stderr, "             -a        overwrite all existing files\n");
      fprintf(stderr, "             -c hosts  accept specified clients only\n");
      fprintf(stderr, "             -f[n]     use filter n specified in PFTPSFILTER\n");
      fprintf(stderr, "             -r        receive directories recursively\n");
      fprintf(stderr, "             -s        skip all existing files\n\n");
      fprintf(stderr, "  Client: %s [port] [OPTIONS] [-l|-NUM| hostname]", *argv);
      fprintf(stderr, " [files]\n");
      fprintf(stderr, "             -[b[NUM]] send stdin [buffered] (incompatible with `-l')\n");
      fprintf(stderr, "             -f[n]     use filter n specified in PFTPCFILTER\n");
      fprintf(stderr, "             -l        select hostname from list and send files\n");
      fprintf(stderr, "             -NUM      destination host by number from hostname list\n");
      fprintf(stderr, "             -oN1oN2   begin sending at the N1th byte of the first\n");
      fprintf(stderr, "                       file, at the N2th byte of the second file etc.\n");
      fprintf(stderr, "                       (Read the manual page for further notices!)\n");
      fprintf(stderr, "             -r        send directories recursively\n\n");
      exit(1);
}

int argum(int argc, char **argv, int *portn)
{
   int _ISDIGIT_=0;
   (*statstr)->usefilter = 0;
   *offset = -1;

   /*
    * Please don't change this option.
    */
   if (argc == 2 && (strcmp(argv[1], "-H") == 0)) {
         fprintf(stderr, "\n*** \
  This program is dedicated to Heather O'Rourke   ***\n\n");
         exit(2);
   }
   else if (argc == 1) {
      (*statstr)->_OPTIONS_=1;
      *portn=-1;
      lhost(NULL, portn);
      return 1;
   }
   else if (argc == 2 && (atoi(argv[1]) && strlen(argv[1]) > 6) && argv[1][0] != '-') {
      return 1;
   }
   else if (argv[1][0] == '-' || argc > 1) {
      int i, j, c, _NEXT_, cl=0;
      char *home=NULL, *gtmp=NULL;
      short clhosts=0;

      if (!strcmp(argv[1], "-h")) help(argv);
      else if (argv[1][0] == '-' || !atoi(argv[1]) || strlen(argv[1]) > 5) {
         *portn=-1;
         lhost(NULL, portn);
         (*statstr)->_OPTIONS_ = 1;
      }
      else (*statstr)->_OPTIONS_ = 2;

      /*
       * Set pftplog if specified.
       */
      lhost(NULL, portn);

      while ((*statstr)->_OPTIONS_ < argc && argv[(*statstr)->_OPTIONS_][0] == '-') {
         _NEXT_ = 1;
         clhosts = 0;
         for (i=1; _NEXT_ && (c = argv[(*statstr)->_OPTIONS_][i]); i++) {
            switch(c) {
               case 'c':
                  /* get host names of accepted clients */
                  if (argc > (*statstr)->_OPTIONS_ + 1) {
                     if (!getenv("PFTPCLIENTS") && *argv[(*statstr)->_OPTIONS_+1] == '-') {
                        MEM_CHECK((gtmp = (char *)calloc(SONAME, sizeof(char))));
                        if (!get_var_from_pftprc("PFTPCLIENTS", gtmp)) help(argv);
                     }
                     else if (*argv[(*statstr)->_OPTIONS_+1] != '-') clhosts = 1;
                  }
                  else if (argc == (*statstr)->_OPTIONS_ + 1) {
                     if (!getenv("PFTPCLIENTS")) {
                        MEM_CHECK((gtmp = (char *)calloc(SONAME, sizeof(char))));
                        if (!get_var_from_pftprc("PFTPCLIENTS", gtmp)) help(argv);
                     }
                  }
                  if (!*_CLIENTHOSTNAME_) fprintf(stderr, "\n*** Connections are accepted from the following host(s) ***\n\n");
                  for (cl=0; cl < MAXCLIENTHOSTS && *(_CLIENTHOSTNAME_+cl); cl++);
                  /*
                   * Get name of resource file.
                   */
                  MEM_CHECK((home = (char *)calloc(SONAME, sizeof(char))));
                  strcpy(home, getenv("HOME"));
                  strcat(home, PFTPRESOURCE);

                  /*
                   * Read from command line.
                   */
                  if (clhosts) {
                     for (; ++(*statstr)->_OPTIONS_ < argc && argv[(*statstr)->_OPTIONS_][0] != '-'; cl++) {
                        MEM_CHECK((_CLIENTHOSTNAME_[cl] = (char *) calloc(SONAME, sizeof(char))));
                        printlist(cl, argv[(*statstr)->_OPTIONS_], home);
                     }
                     if (!*_CLIENTHOSTNAME_) help(argv);
                     _NEXT_ = 0;
                     (*statstr)->_OPTIONS_--;
                     continue;
                  }
                  /*
                   * Read from environment variable or resource file.
                   */
                  else if (getenv("PFTPCLIENTS") || gtmp) {
                     char *tmp=NULL;
                     if (getenv("PFTPCLIENTS")) {
                        if (!gtmp) MEM_CHECK((gtmp = (char *) calloc(SONAME, sizeof(char))));
                        strcpy(gtmp, getenv("PFTPCLIENTS"));
                     }
                     tmp = gtmp;
                     while (*tmp == ' ' || *tmp == '*') tmp++;
                     for (; *tmp; cl++) {
                        MEM_CHECK((_CLIENTHOSTNAME_[cl] = (char *) calloc(SONAME, sizeof(char))));
                        tmp += printlist(cl, tmp, home);
                        while (*(++tmp) == ' ' || *tmp == '*');
                     }
                     if (!*_CLIENTHOSTNAME_) help(argv);
                     free(gtmp);
                  }
                  else help(argv);
                  break;
               case 'B':
               case 'b':
                  if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) { 
                     char *tmp = NULL;
                     size_t bf = (size_t)0;

                     for (tmp=argv[(*statstr)->_OPTIONS_],++i; isdigit(*(tmp+i)); i++) {
                           bf = (bf * 10) + (size_t) (*(tmp+i) - '0');
                     }
                     MEM_CHECK((_STDOUT_BUFFER_ = calloc(bf, sizeof(char))));
                     MEM_CHECK(((*statstr)->_STDIN_BUFFER_ = calloc(bf, sizeof(char))));
                     (*statstr)->_STDIN_BUFSIZ_ = bf;
                     i--;
                  } 
                  else {
                     MEM_CHECK((_STDOUT_BUFFER_ = calloc((size_t)(c == 'b' ? DEFAULT_STDIN_BUFSIZ: BUFSIZE), sizeof(char))));
                     MEM_CHECK(((*statstr)->_STDIN_BUFFER_ = calloc((size_t)(c == 'b' ? DEFAULT_STDIN_BUFSIZ: BUFSIZE), sizeof(char))));
                     (*statstr)->_STDIN_BUFSIZ_ = (c == 'b' ? DEFAULT_STDIN_BUFSIZ: BUFSIZE);
                  }
                  (*statstr)->_SET_STDIN_BUF_ = 1;
               case '-':
                  (*statstr)->_STANDARD_INPUT_ = 1;
                  break;
               case 'f':
                  if ((cl = argv[(*statstr)->_OPTIONS_][i+1]) == 'S' || cl == 'C') {
                     char *tmp=NULL;
                     /*
                      * List all Server/Client filters.
                      */
                     if (cl == 'S') {
                        tmp = getenv("PFTPSFILTER");
                        if (!tmp) {
                           MEM_CHECK((tmp = (char *) calloc(SONAME, sizeof(char))));
                           if (!get_var_from_pftprc("PFTPSFILTER", tmp)) {
                              free(tmp);
                              tmp = NULL;
                           }
                        }
                     }
                     else {
                        tmp = getenv("PFTPCFILTER");
                        if (!tmp) {
                           MEM_CHECK((tmp = (char *) calloc(SONAME, sizeof(char))));
                           if (!get_var_from_pftprc("PFTPCFILTER", tmp)) {
                              free(tmp);
                              tmp = NULL;
                           }
                        }
                     }
                     if (!tmp) {
                        fprintf(stderr, "** %s is not set.\n", cl == 'S'?"PFTPSFILTER":"PFTPCFILTER");
                        exit(1);
                     }
                     for (j=0;*(tmp+j) == ' ' && *(tmp+j); j++);
                     if (!*(tmp+j)) {
                        fprintf(stderr, "** %s is empty.\n", cl == 'S'?"PFTPSFILTER":"PFTPCFILTER");
                     }
                     else {
                        int skip_space=1;
                        fprintf(stderr, "\n* List of %s filters:\n\n", cl == 'S'?"server":"client");
                        fprintf(stderr, "      1) ");
                        for (i=0,j=2; *(tmp+i); i++) {
                           if (*(tmp+i) == ':') {
                              fprintf(stderr, "\n      %d) ", j++);
                              skip_space = 1;
                           }
                           else {
                              if (*(tmp+i) == ' ' || *(tmp+i) == '\t') {
                                 while(*(tmp+i) == ' ' || *(tmp+i) == '\t') i++;
                                 if (!skip_space) i--;
                              }
                              skip_space = 0;
                              fputc(*(tmp+i), stderr);
                           }
                        }
                        fprintf(stderr, "\n\n");
                     }
                     exit(0);
                  }
                  else {
                     for (j=1,(*statstr)->usefilter=0; isdigit(argv[(*statstr)->_OPTIONS_][i+j]); j++) {
                        if ((*statstr)->usefilter) (*statstr)->usefilter *= 10;
                        (*statstr)->usefilter += argv[(*statstr)->_OPTIONS_][i+j] - '0';
                     }
                     if (j == 1) (*statstr)->usefilter++;
                     i += j - 1;
                  }
                  break;
               case 'o':
                  if (*offset < 0) getoffset(argv[(*statstr)->_OPTIONS_]);
                  break;
               case 'r':
                  (*statstr)->_RECURS_ = 1;
                  break;
               case 'a':
                  (*statstr)->OVERWRITE = BIT_TWO;
                  break;
               case 'l':
                  if (_ISDIGIT_ == 1) help(argv);
                  else _ISDIGIT_ = (*statstr)->_OPTIONS_+1;
                  break;
               case 's':
                  (*statstr)->_SKIP_ = 1;
                  break;
               case 'h':
                  help(argv);
                  break;
               default:
                  if (_ISDIGIT_ > 1 || !isdigit(c)) {
                     fprintf(stderr, "**\n** unknown option `%c'\n**\n", c);
                     help(argv);
                  }
                  else {
                     _ISDIGIT_ = 1;
                     lhost(argv[(*statstr)->_OPTIONS_], portn); 
                  }
                  break;
            }
         }
         if (i == 1) (*statstr)->_STANDARD_INPUT_ = 1;
         (*statstr)->_OPTIONS_++;
      }
      if (home) free(home);
   }
   else if (argc < 3) {
      help(argv);
   }

   /*
    * Indentify and check.
    */
   if(_ISDIGIT_) (*statstr)->_OPTIONS_--;
   if(((*statstr)->OVERWRITE && (*statstr)->_SKIP_) || ((*statstr)->OVERWRITE && _ISDIGIT_)) help(argv);
   /*
    * If the program is running as the server return 1 else 
    * if the program is running as the client return 0.
    * Print help a message if an error occurs.
    */
   else if ((((argc == 2) && (!isalpha(argv[1][0]))) \
        || ((*statstr)->_OPTIONS_ == argc)) && (!_ISDIGIT_) && (*offset < 0)) 
        /*
         * Program is running as the server.
         */
        return 1;
   else if (((*statstr)->OVERWRITE || (*statstr)->_SKIP_ || *_CLIENTHOSTNAME_) \
        || (_ISDIGIT_ > 1 && (*statstr)->_STANDARD_INPUT_) \
        || ((*statstr)->_RECURS_ && (*statstr)->_STANDARD_INPUT_) \
        || ((*statstr)->_RECURS_ && !_ISDIGIT_ && (*statstr)->_OPTIONS_ == argc - 1) \
        || ((*statstr)->_STANDARD_INPUT_ && argv[argc-2][0] != '-') \
        || (!(*statstr)->_STANDARD_INPUT_ && argv[argc-1][0] == '-') \
        || ((*statstr)->_STANDARD_INPUT_ && argv[argc-1][0] != '-'  && _ISDIGIT_))
           help(argv);
   else if (_ISDIGIT_ > 1) lhost(argv[_ISDIGIT_ - 1], portn);
   if (_ISDIGIT_ > 1 && (*statstr)->_OPTIONS_ == argc - 1) {
      fprintf(stderr, "** No files specified!\n");
      exit(1);
   }

   /*
    * Program is running as the client.
    */
   return 0;
}


int printlist(int cl, char *chost, char *home)
{
   char *clienthost = NULL;
   struct hostent *hp;
   short _ISNUM_=1;
   char *tmphost=NULL;
   int inum, j, tmp;

   MEM_CHECK((clienthost = (char *)calloc(SONAME, sizeof(char))));
   strcpy(clienthost, chost);
   for (j=0; *(clienthost+j) != ' ' && *(clienthost+j); j++)
      if (!isdigit(*(clienthost+j))) _ISNUM_=0;
   *(clienthost+j) = '\0';
   tmp = j;
   if (!_ISNUM_) {
      tmphost = clienthost;
   }
   else {
      int dummy;
      shost(atoi(clienthost), &dummy, home);
      tmphost = (*statstr)->_HOSTNAME_;
   }
   inum = inet_addr(tmphost);
   if (*tmphost != '.') {
      if ((hp = (struct hostent *)gethostbyname(tmphost)) != NULL);
      else if ((hp = gethostbyaddr((char *)&inum, sizeof(inum), AF_INET)) == 0) {
         fprintf(stderr, "** %s: unknown host.\n", tmphost);
         exit(1);
      }
      fprintf(stderr, "   %d) %s\n", cl+1, hp->h_name);
      for (j=0; *(hp->h_name+j); j++) _CLIENTHOSTNAME_[cl][j] = tolower(*(hp->h_name+j));
   }
   else {
      fprintf(stderr, "   %d) *%s\n", cl+1, tmphost);
      for (j=0; *(tmphost+j); j++) _CLIENTHOSTNAME_[cl][j] = tolower(*(tmphost+j));
   }
   free(clienthost);
   return tmp;
}

void getoffset(char *z)
{
   long *t = offset;

   for (*t=0L,z += 2; *z; z++) {
      if (isdigit(*z)) *t = (*t * 10) + (long) (*z - '0');
      else if (*z == 'o' && isdigit(*(z+1))) {
         t++;
         *t = 0L;
      }
   }
   t++;
   *t = -1;
}
