.TH PFTP 1L "GNU File Transfer Utilities" "FSF" \" -*- nroff -*-
.SH NAME
pftp \- file transfer program
.SH SYNOPSIS
.br
Server:
.B pftp
[portnumber] [OPTIONS]
.br
.br
Client:
.B pftp
[portnumber] [OPTIONS] [hostname] [files]
.BR
.SH DESCRIPTION
This manual page
documents the GNU version of
.BR pftp .
.BR pftp
copies files from host to host.  All space, tabkey, and line feed characters
contained in file and directory names are transfered to underline characters.
There is no authorization mechanism necessary but possible.  Up to five
connections are possible at a time.  First the server has to be started at the
destination host with a port number in the range of 1025 and at least 32767.
Thereafter the client may send files to the port of the destination host.  See
section
.BR EXAMPLES
for further information.

.SS OPTIONS
.TP
.I "\-"
The client sends all standard input to the destination host.
If the client and the server are started with this option, the
server sends all bytes to standard output.  If on the other
hand the server was started with this option, but the client
sends regular files, the server copies all files within the
first connection and exits afterwards. If only the client was
started with the option, the server copies the received stream
to a file called
.IR Stream.x .
.IR x
is an increasing number beginning at 1.  The default buffer size for
`-' is BUFSIZ (probably 1024).  
.TP
.I "\-b[NUM]"
Same as `-' except that all sent data is buffered.  You may set the
buffer size with `NUM'.
.BR pftp
does not limit this value.  So whatever your system supports you may
set (see
.BR BUGS ).
Values between one and 32767 are always possible.  The default buffer
size for `-b' is 4096.
.TP
.I "\-B"
Same as `-b32767'.
.TP
.I "\-a"
Always overwrite existing files. (Server option only)
.TP
.I "\-c hostnames"
Connections are accepted from clients with specified host names only.
All other clients are simply refused. Host names can also be given
as numbers which are looked up in your
.BR pftp
resource file (see
.BR RESOURCES ).
If no host names are specified the environment variable
.IR PFTPCLIENTS
is read instead (see
.BR ENVIRONMENT ).
You may also specify domain names:  All client host names that begin
with a dot are supposed to be domain names.
(Server option only)
.TP
.I "\-f[n]"
Filter all files before sending them over the network, i.e. the
standard output of the filter on the client side is connected to the
standard input of the filter on the server side.  The filters are
specified by
.IR PFTPCFILTER
respectively
.IR PFTPSFILTER
(see
.BR ENVIRONMENT ).
.TP
.I "\-l"
List host names from file `.pftprc' and send files. Cannot be combined
with option `-'!  (Client option only)
.TP
.I "\-NUM"
Choose host NUM from host name list. (Client option only)
.TP
.I "\-oN1oN2..."
Seek the N1th offset from the beginning of the first file, the N2th offset
from the beginning of the second file etc.  If a file is incomplete
received then you may try to send just the missing part of the file, i.e.
N1 respectively N2 is the size of the incomplete file. I suggest to
truncate the incomplete file by a several bytes at first. Then start the
server in the appropriate directory and choose `a' when the
server asks you. Nevertheless this option is still experimental! (Client option only)
.TP
.I "\-r"
If the server and the client are started with this option,
all files received from the client are copied into the
appropriate directories. If necessary
.BR pftp
creates new directories within the current directory, i.e.
the directory where the server was started from. If only
the client is started with this option, all files sent by
the client are copied into the current directory.
.TP
.I "\-s"
Always skip existing files. (Server option only)
.PP
.SS EXAMPLES
In order to send two files start the server with a port number at
your choice at the destination host (port numbers between 1025 and
32767 are always legal unless they are in use\-\-then simply choose
another port number):
.sp
.RS +.5i
pftp 1234
.RE
.sp
Then start the client with the same port number at the origin host:
.sp
.RS +.5i
pftp 1234 destinationhost file1 file2
.RE
.sp
The server is waiting for connections until you kill it, e.g. with ^C.
.PP
Now we want to copy the current directory including all subdirectories.
Start the server at the destination host with option `-r':
.sp
.RS +.5i
pftp 1234 -r
.RE
.sp
And analogeously start the client with the same option:
.sp
.RS +.5i
pftp 1234 -r destinationhost .
.RE
.sp
I suggest to create the file `.pftprc' to start
.BR pftp
with a default port number. See section
.BR RESOURCES
for further details.
.sp
To send standard input using the default port number  start the server with
option `-' and redirect the standard output wherever you want to:
.sp
.RS +.5i
pftp - > file
.RE
.sp
The client is started as usual but this time with option `-':
.sp
.RS +.5i
pftp - destinationhost_or_host_number < file
.RE
.sp
Though
.BR pftp
is not meant to send messages to the destination host, it is possible,
but without any comfort, for this is a file transfer program.
.SH RESOURCES
If you want to start
.BR pftp
with a default port number, create the file `.pftprc' in your home directory
and enter your default port number on the first line.  Each line that
follows may hold one host name followed by a port number. If no following
port number is specified, the default port number is taken.
Lines beginning with a hash or a new line character are ignored.
.SH ENVIRONMENT
If the environment variable
.IR PFTPLOG
is set to the absolute path
of an error file,
.BR pftp
logs all error messages that occur while sending files in the error file.
For example:
.sp
.RS +.5i
.ta 0.5i 1.0i
.nf
for sh:   PFTPLOG="$HOME/pftp.log" ; export PFTPLOG
for csh:  setenv PFTPLOG "$HOME/pftp.log"
.fi
.RE
.sp
You may also set all variables after the first line and before the host
name list in your resource file.  Since the client does not exit on errors
concerning unreadable or empty files and directories, it might be useful
to log the error messages.  So you can send these mostly few files
afterwards.
.sp
The environment variable
.IR PFTPCLIENTS
may hold all client host names that are accepted.  The names are
seperated by spaces.  So if `-c' follows no host name that variable is
read instead.  Of course the client may fake its host name as long as
a user has root privileges and hacks the client's source code.  But
since the server does not create files or directories in upper
directories no user should have a real interest to make an effort to
hack the source code.  For security reasons you may choose an
encryption filter for the connection with option `-fn'.
.sp
If on the client side the variable
.IR PFTPCFILTER
and on the server side the variable
.IR PFTPSFILTER
hold names of filter programs with possible options the filters will
be used if `-f' is given on command line.  The variables may hold
several filters.  All filter programs have to be seperated by a colon.
You may choose a specific filter program with `-fn' where n is the
number of the filter program.  The first filter program has number 1.
If n is not given the first filter program will be used.  In order to
list all client filters set n to C, to list all server filters set n
to S.  Keep in mind that the filter on the client side is just the
opposite of the filter on the server side!
.SH AUTHOR
Ben Schluricke
.SH DEDICATION
This program is dedicated to
.BR "Heather O'Rourke" .
.SH "SEE ALSO"
ftp(1), rsh(1), rcp(1)
.SH BUGS
Setting the buffer size to zero with option `-b' may crash older
systems.  So you should use a buffer size of zero for test purposes
only.  Most newer systems set a buffer size of zero to one by default.

If you find any bug, please drop me an e-mail.
.sp
.RS +.5i
bhor0533@lehr.chem.TU-Berlin.DE
.RE
.sp
Every comment via e-mail will be appreciated!
