/**************************************************************************** 
** File: arp.c
**
** Author: Mike Borella
**
** Comments: Dump ICMP header information
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include "config.h"
#include "arp.h"

extern u_char *packet_end;

void dump_arp(u_char *bp, int length, int caplen)
{
  EtherARP *ap;
  u_short pro, hrd, op;
  struct in_addr spa, tpa;
  char *etheraddr_string(u_char *ep);
  
  /*
   * ARP header announcement
   */

  printf("----------------------------------------------------------\n");
  printf("			ARP Header\n");
  printf("----------------------------------------------------------\n");

  /*
   * Check for truncated packet
   */
  
  ap = (EtherARP *) bp;
  if (length < sizeof(EtherARP)) 
    {
      printf("Truncated packet\n");
      return;
    }

  /*
   * Dump ARP header fields 
   */

  hrd = ntohs(ap->ea_hdr.ar_hrd);
  pro = ntohs(ap->ea_hdr.ar_pro);
  op = ntohs(ap->ea_hdr.ar_op);
  
  printf("Hardware type:          %d\n", hrd);
  printf("Protocol:               %d\n", pro);
  printf("Operation:              %d ", op);

  /*
   * Figure out type of ARP
   */

  switch (op) 
    {    
    case ARPOP_REQUEST:
      printf("(ARP request)\n");
      break;
      
    case ARPOP_REPLY:
      printf("(ARP reply)\n");
      break;
      
    case ARPOP_RREQUEST:
      printf("(RARP request)\n");
      break;
      
    case ARPOP_RREPLY:
      printf("(RARP reply)\n");
      break;
      
    default:
      printf("(unknown)\n");
      return;
    }
  
  /*
   * Dump hardware and IP addresses
   */
  
  memcpy((void *) &spa, (void *) &ap->arp_spa, sizeof (struct in_addr));
  memcpy((void *) &tpa, (void *) &ap->arp_tpa, sizeof (struct in_addr));

  printf("Sender hardware:        %s\n", etheraddr_string(ap->arp_sha));
  printf("Sender IP:              %s\n", inet_ntoa(spa));
  printf("Target hardware:        %s\n", etheraddr_string(ap->arp_tha));
  printf("Target IP:              %s\n", inet_ntoa(tpa));
  
}




