/*
 * ctcp.h: header file for ctcp.c
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: ctcp.h,v 1.5 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _CTCP_H_
#define _CTCP_H_

#include "irc.h"
#include "irc_std.h"

#define CTCP_PRIVMSG 	0
#define CTCP_NOTICE 	1

#define CTCP_SED	0
#define CTCP_UTC	1
#define CTCP_ACTION	2
#define CTCP_DCC	3
#define CTCP_VERSION	4
#define CTCP_CLIENTINFO	5
#define CTCP_USERINFO	6
#define CTCP_ERRMSG	7
#define CTCP_FINGER	8
#define CTCP_TIME	9
#define CTCP_PING	10
#define	CTCP_ECHO	11
#define CTCP_CUSTOM	12
#define NUMBER_OF_CTCPS	CTCP_CUSTOM

extern		char	*ctcp_type[];
extern		int	sed;
extern		int	in_ctcp_flag;

#define CTCP_DELIM_CHAR '\001'
#define CTCP_DELIM_STR 	"\001"
#define CTCP_QUOTE_CHAR '\\'
#define CTCP_QUOTE_STR 	"\\"
#define CTCP_QUOTE_EM 	"\r\n\001\\"


extern	char *	ctcp_quote_it _((char *, int));
extern	char *	ctcp_unquote_it _((char *, int *));
extern	char *	do_ctcp _((char *, char *, char *));
extern	char *	do_notice_ctcp _((char *, char *, char *));
extern	int	in_ctcp _((void));
extern	void	send_ctcp _((int, char *, int, char *, ...));
extern	int	get_ctcp_val _((char *));

#endif /* _CTCP_H_ */
