/*
 *  Copyright (C) 1998 Friedrich Leisch and Andreas Weingessel
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <math.h>

double mdian1_(double *x, int *n);

int assign(int *xrows, int *xcols, double *x, int *ncenters,
	   double *centers, int *cluster, int *clustersize,
	   int *method)
{
  int k, m, n;
  double dist, mindist;

  for(k=0; k<*xrows; k++){
    mindist=10e99;

    for(m=0; m< *ncenters; m++){
      dist=0;
      for(n=0;n<*xcols;n++){
	if(*method == 0){
	  dist += (x[k+(*xrows)*n] - centers[m + (*ncenters)*n])*(x[k+(*xrows)*n] - centers[m + (*ncenters)*n]);
	}
	else if(*method ==1){
	  dist += fabs(x[k+(*xrows)*n] - centers[m + (*ncenters)*n]);
	}
	
      }

      if(dist<mindist){
	cluster[k] = m;
	mindist = dist;
      }
    }
  }

  
  for(k=0;k<*ncenters;k++){
    clustersize[k]=0;
  } 
  for(k=0; k<*xrows; k++){
    clustersize[cluster[k]]++;
  }

  return 0;
}

		 
int reloc(int *xrows, int *xcols, double *x, int *ncenters,
	  double *centers, int *cluster, int *clustersize,
	  int *method)
{
  int k,l,m,n; double xxx; 

  /* Initialize cluster size and centers with 0 */
  for(k=0;k<*ncenters;k++){
    clustersize[k]=0;
    for(m=0;m<*xcols;m++){
      centers[k+(*ncenters)*m] = 0;
    }
  }

  for(k=0; k<*xrows; k++)
     clustersize[cluster[k]]++;
  
  if(*method==0){
    /* Euclidean distance */
    for(k=0; k<*xrows; k++){
      for(m=0;m<*xcols;m++){
	centers[cluster[k]+(*ncenters)*m] += x[k+(*xrows)*m];
      }
    }
    
    for(k=0; k<*ncenters; k++){
      for(m=0;m<*xcols;m++){
	centers[k+(*ncenters)*m] /= clustersize[k];
      }
    }
  }
  else if(*method == 1){
    for(k=0; k<*ncenters; k++){
      double xk[clustersize[k]];
      int i;
      for (m=0; m<*xcols; m++){
	i=0;
	for (l=0; l<*xrows; l++)
	  if(cluster[l]==k){
	    xk[i] = x[l+(*xrows)*m];
	    i++;
	  }
	centers[k+(*ncenters)*m] = mdian1_(xk, &clustersize[k]);
	/*printf("xxx=%lf\n",mdian1_(xk, &clustersize[k]));*/
	/*printf("%lf\n", ;*/
	  }
    }
  }
  return 0;
}


int kmeans(int *xrows, int *xcols, double *x, int *ncenters,
	  double *centers, int *cluster,
	   int *itermax, int *iter, int *changes,
	   int *clustersize, int *verbose, int *method)
{
  int m;
  int change;
  int clustnew[*xrows];

  
  change = 1;
  *iter=0;
  while(change && ((*iter)++ < *itermax)){
    assign(xrows, xcols, x, ncenters, centers, clustnew, clustersize, method);
    reloc(xrows, xcols, x, ncenters, centers, clustnew, clustersize, method);
    change = 0;
    for(m=0; m<*xrows; m++){
      if(cluster[m] != clustnew[m]){
	change++;
	cluster[m] = clustnew[m];
      }
    }
    if(*verbose){
      printf("Iteration %6d: %10d changes\n", *iter, change);
    }
    changes[(*iter)-1] = change;
  }
  return 0;
}
     
