#
# PGP functions to query for public keys via WWW
# author: Carl Roth <roth@cse.ucsc.edu>
#

#
# query the keyserver:
#

proc PgpQueryKey {id} {
    global pgp

    # dispatch based on whether we use email or WWW:
    switch $pgp(keyquerymethod) {
	WWW { PgpQueryWWWKey $id }
	email { Misc_Send $pgp(keyserver) "GET 0x$id" }
	default { PgpQueryOtherKey $id }
    }
}

proc pgp_make_msg {id file} {
    global exmh

    set rcvstore [file dirname $exmh(slocal)]/rcvstore
    set pipe [open "|$rcvstore +$exmh(folder)" w]
    puts $pipe "Mime-Version: 1.0 (generated by exmh)"
    puts $pipe "Content-Type: application/pgp; format=keys-only"
    puts $pipe "Date: [exec date]"
    puts $pipe "From: system"
    puts $pipe "Subject: Output of pgp on id $id"
    puts $pipe ""

    exec cat $file >@$pipe
    close $pipe

    # update the folder listing:
    Flist_FindUnseen
    busy Scan_FolderForce
}

proc PgpQueryStatus {state count length} {
    if {$length} {
	Exmh_Status [format "%s... %.1f%% complete" \
			 $state [expr 100.0 * $count / $length]]
    } else {
	Exmh_Status [format "%s..." $state]
    }
}

proc PgpQueryDone {url file} {
    global pgp

    upvar #0 $url data
    if {[info exists data(html)]} {
	set fd [open $file w]
	puts -nonewline $fd $data(html)
	close $fd
    }
    set pgp(querydone) 1
}

proc PgpQueryWWWKey {key} {
    global pgp
    set url [format $pgp(keyserverURL) $key]
    set pgp(querydone) 0
    Exmh_Status "posting query $url"

    set tmp [Mime_TempFile "pgpkey"]
    Http_get $url "PgpQueryDone $url $tmp" PgpQueryStatus
    tkwait variable pgp(querydone)
    if {[file exists $tmp]} {
	Exmh_Status "Saving key $key"
	if [PgpExec_ExtractKeys $tmp 0] {
	    exec rm -f $tmp
	}
    } else {
	Exmh_Status "unable to fetch key!"
    }
}

#
# query a key using an external function
#

proc PgpQueryOtherKey {id} {
    global env pgp

    Exmh_Status "querying for key \[$id\]..."

    set tmp [Mime_TempFile "pgpkey"]
    set cmd [eval $pgp(keyothermethod)]
    if {[catch $cmd result]} {
	Exmh_Status [format "unable to get key: %s" \
			 [lindex [split $key "\n"] 0]]
    } else {
	Exmh_Status "filing response"
	pgp_make_msg $id $tmp
    }
    exec rm -f $tmp
}

proc PgpWWW_Init {} {
    global pgp

    Preferences_Add "PGP interface" {} {
	{pgp(keyquerymethod) pgpKeyQueryMethod {CHOICE WWW email other} {Method for querying PGP keys}
"PGP public keys can be queried using email servers
(offline) or using WWW servers (interactive).
A user-supplied proc (other) can also be given to fetch the key." }
        {pgp(keyserverURL) pgpKeyServerURL {http://www-swiss.ai.mit.edu/htbin/pks-extract-key.pl?op=get&search=0x%s} {URL to fetch keys interactively}
"The WWW keyserver is forms based.  Enter a URL here where
the key id (sans 0x) is substituted with %s (using format)" }
        {pgp(keyothermethod) pgpKeyOtherMethod {exec echo "can't find $id" > $tmp} {Other method to fetch a PGP key}
"The external method need to fetch the id in \$id and place
it into the temp file \$tmp." }

    }
}

