/*								-*- C++ -*-
 * $Id: WIN_text.h,v 1.2 1997-01-15 14:58:09+01 mho Exp $
 *
 * Purpose: text panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Text_h
#define Text_h

#ifdef __GNUG__
#pragma interface
#endif

class wxKeyEvent;
class wxPanel;

class wxText : public wxItem {
DECLARE_DYNAMIC_CLASS(wxText)
public:
    wxText(void);
    wxText(wxPanel *panel, wxFunction func, Const char *label,
	   Constdata char *value=wxEmptyString,
	   int x=-1, int y=-1, int width=-1, int height=-1,
	   long style=0, Constdata char *name=wxTextNameStr);
    ~wxText(void);
    
    Bool Create(wxPanel *panel, wxFunction func, Const char *label,
		Constdata char *value=wxEmptyString,
		int x=-1, int y=-1, int width=-1, int height=-1,
		long style=0, Constdata char *name=wxTextNameStr);

    char *GetValue(void);
    void SetValue(char *value);

    void SetEditable(Bool editable);
    // move cursor to end of string
    void ShowEnd(void);
    // Clipboard operations
    void Copy(void);
    void Cut(void);
    void Paste(void);
    // OnChar handles pressing of ENTER if wanted
    void OnChar(wxKeyEvent& event);
private:
    void Delete(void);
    #ifdef Have_Xt_Types
    static void EventCallback(Widget, XtPointer, XtPointer);

    friend void wxTextEnter(Widget, XEvent*, String*, Cardinal*);
    #endif
protected:
    Bool quoted;
    static char* theClipBoard;
};

#endif // Text_h
